% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{discretise}
\alias{discretise}
\alias{discretize}
\title{Discretise a <dist_spec>}
\usage{
discretise(x, strict = TRUE)

discretize(x, strict = TRUE)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{strict}{Logical; If \code{TRUE} (default) an error will be thrown if a
distribution cannot be discretised (e.g., because no finite maximum has been
specified or parameters are uncertain). If \code{FALSE} then any distribution
that cannot be discretised will be returned as is.}
}
\value{
A \verb{<dist_spec>} where all distributions with constant parameters are
nonparametric.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
By default it will discretise all the distributions it can discretise
(i.e. those with finite support and constant parameters).
}
\details{
Discretise a <dist_spec>
}
\examples{
# A fixed gamma distribution with mean 5 and sd 1.
dist1 <- Gamma(mean = 5, sd = 1, max = 20)

# An uncertain lognormal distribution with mean 3 and sd 2
dist2 <- LogNormal(mean = Normal(3, 0.5), sd = Normal(2, 0.5), max = 20)

# The maxf the sum of two distributions
discretise(dist1 + dist2, strict = FALSE)
}
