% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{trunc_opts}
\alias{trunc_opts}
\title{Truncation Distribution Options}
\usage{
trunc_opts(dist = dist_spec())
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions reflecting
the truncation generated using \code{\link[=dist_spec]{dist_spec()}} or \code{\link[=estimate_truncation]{estimate_truncation()}}.
Default is an empty call to \code{\link[=dist_spec]{dist_spec()}}, i.e. no truncation}
}
\value{
A list summarising the input truncation distribution.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns a truncation distribution formatted for usage by
downstream functions. See \code{estimate_truncation()} for an approach to
estimate these distributions.
}
\examples{
# no truncation
trunc_opts()

# truncation dist
trunc_opts(dist = dist_spec(mean = 3, sd = 2, max = 10))
}
\seealso{
convert_to_logmean convert_to_logsd bootstrapped_dist_fit dist_spec
}
\author{
Sam Abbott

Sebastian Funk
}
