// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_simulate_secondary_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_simulate_secondary");
    reader.add_event(1, 1, "include", "functions/pmfs.stan");
    reader.add_event(1, 0, "start", "functions/pmfs.stan");
    reader.add_event(55, 54, "end", "functions/pmfs.stan");
    reader.add_event(55, 2, "restart", "model_simulate_secondary");
    reader.add_event(55, 2, "include", "functions/convolve.stan");
    reader.add_event(55, 0, "start", "functions/convolve.stan");
    reader.add_event(106, 51, "end", "functions/convolve.stan");
    reader.add_event(106, 3, "restart", "model_simulate_secondary");
    reader.add_event(106, 3, "include", "functions/observation_model.stan");
    reader.add_event(106, 0, "start", "functions/observation_model.stan");
    reader.add_event(239, 133, "end", "functions/observation_model.stan");
    reader.add_event(239, 4, "restart", "model_simulate_secondary");
    reader.add_event(239, 4, "include", "functions/secondary.stan");
    reader.add_event(239, 0, "start", "functions/secondary.stan");
    reader.add_event(293, 54, "end", "functions/secondary.stan");
    reader.add_event(293, 5, "restart", "model_simulate_secondary");
    reader.add_event(304, 16, "include", "data/secondary.stan");
    reader.add_event(304, 0, "start", "data/secondary.stan");
    reader.add_event(310, 6, "end", "data/secondary.stan");
    reader.add_event(310, 17, "restart", "model_simulate_secondary");
    reader.add_event(311, 18, "include", "data/simulation_delays.stan");
    reader.add_event(311, 0, "start", "data/simulation_delays.stan");
    reader.add_event(315, 4, "end", "data/simulation_delays.stan");
    reader.add_event(315, 19, "restart", "model_simulate_secondary");
    reader.add_event(316, 20, "include", "data/simulation_observation_model.stan");
    reader.add_event(316, 0, "start", "data/simulation_observation_model.stan");
    reader.add_event(323, 7, "end", "data/simulation_observation_model.stan");
    reader.add_event(323, 21, "restart", "model_simulate_secondary");
    reader.add_event(345, 41, "end", "model_simulate_secondary");
    return reader;
}
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
discretised_gamma_pmf(const std::vector<int>& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(y));
        current_statement_begin__ = 5;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 6;
        local_scalar_t__ trunc_pmf(DUMMY_VAR__);
        (void) trunc_pmf;  // dummy to suppress unused var warning
        stan::math::initialize(trunc_pmf, DUMMY_VAR__);
        stan::math::fill(trunc_pmf, DUMMY_VAR__);
        current_statement_begin__ = 8;
        local_scalar_t__ small(DUMMY_VAR__);
        (void) small;  // dummy to suppress unused var warning
        stan::math::initialize(small, DUMMY_VAR__);
        stan::math::fill(small, DUMMY_VAR__);
        stan::math::assign(small,1e-5);
        current_statement_begin__ = 9;
        local_scalar_t__ large(DUMMY_VAR__);
        (void) large;  // dummy to suppress unused var warning
        stan::math::initialize(large, DUMMY_VAR__);
        stan::math::fill(large, DUMMY_VAR__);
        stan::math::assign(large,1e8);
        current_statement_begin__ = 10;
        local_scalar_t__ c_sigma(DUMMY_VAR__);
        (void) c_sigma;  // dummy to suppress unused var warning
        stan::math::initialize(c_sigma, DUMMY_VAR__);
        stan::math::fill(c_sigma, DUMMY_VAR__);
        stan::math::assign(c_sigma,(logical_lt(sigma, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(sigma) ));
        current_statement_begin__ = 11;
        local_scalar_t__ c_mu(DUMMY_VAR__);
        (void) c_mu;  // dummy to suppress unused var warning
        stan::math::initialize(c_mu, DUMMY_VAR__);
        stan::math::fill(c_mu, DUMMY_VAR__);
        stan::math::assign(c_mu,(logical_lt(mu, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(mu) ));
        current_statement_begin__ = 12;
        local_scalar_t__ alpha(DUMMY_VAR__);
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha, DUMMY_VAR__);
        stan::math::assign(alpha,pow((c_mu / c_sigma), 2));
        current_statement_begin__ = 13;
        local_scalar_t__ beta(DUMMY_VAR__);
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta, DUMMY_VAR__);
        stan::math::assign(beta,(c_mu / pow(c_sigma, 2)));
        current_statement_begin__ = 15;
        stan::math::assign(alpha, (logical_lt(alpha, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 16;
        stan::math::assign(alpha, (logical_gt(alpha, large) ? stan::math::promote_scalar<local_scalar_t__>(large) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 17;
        stan::math::assign(beta, (logical_lt(beta, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 18;
        stan::math::assign(beta, (logical_gt(beta, large) ? stan::math::promote_scalar<local_scalar_t__>(large) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 20;
        stan::math::assign(trunc_pmf, (gamma_cdf((max_val + 1), alpha, beta) - gamma_cdf(1, alpha, beta)));
        current_statement_begin__ = 21;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 22;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((gamma_cdf((get_base1(y, i, "y", 1) + 1), alpha, beta) - gamma_cdf(get_base1(y, i, "y", 1), alpha, beta)) / trunc_pmf), 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 25;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_gamma_pmf_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) const {
        return discretised_gamma_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
discretised_lognormal_pmf(const std::vector<int>& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 30;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(y));
        current_statement_begin__ = 31;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 32;
        local_scalar_t__ small(DUMMY_VAR__);
        (void) small;  // dummy to suppress unused var warning
        stan::math::initialize(small, DUMMY_VAR__);
        stan::math::fill(small, DUMMY_VAR__);
        stan::math::assign(small,1e-5);
        current_statement_begin__ = 33;
        local_scalar_t__ c_sigma(DUMMY_VAR__);
        (void) c_sigma;  // dummy to suppress unused var warning
        stan::math::initialize(c_sigma, DUMMY_VAR__);
        stan::math::fill(c_sigma, DUMMY_VAR__);
        stan::math::assign(c_sigma,(logical_lt(sigma, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(sigma) ));
        current_statement_begin__ = 34;
        local_scalar_t__ c_mu(DUMMY_VAR__);
        (void) c_mu;  // dummy to suppress unused var warning
        stan::math::initialize(c_mu, DUMMY_VAR__);
        stan::math::fill(c_mu, DUMMY_VAR__);
        stan::math::assign(c_mu,(logical_lt(mu, small) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(mu) ));
        current_statement_begin__ = 35;
        validate_non_negative_index("adj_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> adj_y(n);
        stan::math::initialize(adj_y, DUMMY_VAR__);
        stan::math::fill(adj_y, DUMMY_VAR__);
        stan::math::assign(adj_y,add(to_vector(y), small));
        current_statement_begin__ = 36;
        validate_non_negative_index("upper_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> upper_y(n);
        stan::math::initialize(upper_y, DUMMY_VAR__);
        stan::math::fill(upper_y, DUMMY_VAR__);
        stan::math::assign(upper_y,divide(subtract(stan::math::log(add(adj_y, 1)), c_mu), c_sigma));
        current_statement_begin__ = 37;
        validate_non_negative_index("lower_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lower_y(n);
        stan::math::initialize(lower_y, DUMMY_VAR__);
        stan::math::fill(lower_y, DUMMY_VAR__);
        stan::math::assign(lower_y,divide(subtract(stan::math::log(adj_y), c_mu), c_sigma));
        current_statement_begin__ = 38;
        local_scalar_t__ max_cdf(DUMMY_VAR__);
        (void) max_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(max_cdf, DUMMY_VAR__);
        stan::math::fill(max_cdf, DUMMY_VAR__);
        stan::math::assign(max_cdf,normal_cdf(((stan::math::log((max_val + small)) - c_mu) / c_sigma), 0.0, 1.0));
        current_statement_begin__ = 39;
        local_scalar_t__ min_cdf(DUMMY_VAR__);
        (void) min_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(min_cdf, DUMMY_VAR__);
        stan::math::fill(min_cdf, DUMMY_VAR__);
        stan::math::assign(min_cdf,normal_cdf(((stan::math::log(small) - c_mu) / c_sigma), 0.0, 1.0));
        current_statement_begin__ = 40;
        local_scalar_t__ trunc_cdf(DUMMY_VAR__);
        (void) trunc_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(trunc_cdf, DUMMY_VAR__);
        stan::math::fill(trunc_cdf, DUMMY_VAR__);
        stan::math::assign(trunc_cdf,(max_cdf - min_cdf));
        current_statement_begin__ = 41;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 42;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((normal_cdf(get_base1(upper_y, i, "upper_y", 1), 0.0, 1.0) - normal_cdf(get_base1(lower_y, i, "lower_y", 1), 0.0, 1.0)) / trunc_cdf), 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 45;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_lognormal_pmf_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) const {
        return discretised_lognormal_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse_mf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf,
               const int& max_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 50;
        validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_pmf(max_pmf);
        stan::math::initialize(rev_pmf, DUMMY_VAR__);
        stan::math::fill(rev_pmf, DUMMY_VAR__);
        current_statement_begin__ = 51;
        for (int d = 1; d <= max_pmf; ++d) {
            current_statement_begin__ = 52;
            stan::model::assign(rev_pmf, 
                        stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                        get_base1(pmf, ((max_pmf - d) + 1), "pmf", 1), 
                        "assigning variable rev_pmf");
        }
        current_statement_begin__ = 54;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev_pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse_mf_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf,
               const int& max_pmf, std::ostream* pstream__) const {
        return reverse_mf(pmf, max_pmf, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& cases,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& rev_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 58;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(cases));
        current_statement_begin__ = 59;
        int max_pmf(0);
        (void) max_pmf;  // dummy to suppress unused var warning
        stan::math::fill(max_pmf, std::numeric_limits<int>::min());
        stan::math::assign(max_pmf,num_elements(rev_pmf));
        current_statement_begin__ = 60;
        validate_non_negative_index("conv_cases", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conv_cases(t);
        stan::math::initialize(conv_cases, DUMMY_VAR__);
        stan::math::fill(conv_cases, DUMMY_VAR__);
        stan::math::assign(conv_cases,rep_vector(1e-5, t));
        current_statement_begin__ = 61;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 62;
            stan::model::assign(conv_cases, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (stan::model::rvalue(conv_cases, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "conv_cases") + dot_product(stan::model::rvalue(cases, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - max_pmf) + 1)), s), stan::model::nil_index_list()), "cases"), tail(rev_pmf, std::min(max_pmf, s)))), 
                        "assigning variable conv_cases");
        }
        current_statement_begin__ = 65;
        return stan::math::promote_scalar<fun_return_scalar_t__>(conv_cases);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& cases,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& rev_pmf, std::ostream* pstream__) const {
        return convolve(cases, rev_pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
convolve_to_report(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const std::vector<T1__>& delay_mean,
                       const std::vector<T2__>& delay_sd,
                       const std::vector<int>& max_delay,
                       const int& seeding_time, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 75;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(infections));
        current_statement_begin__ = 76;
        validate_non_negative_index("reports", "(t - seeding_time)", (t - seeding_time));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports((t - seeding_time));
        stan::math::initialize(reports, DUMMY_VAR__);
        stan::math::fill(reports, DUMMY_VAR__);
        current_statement_begin__ = 77;
        validate_non_negative_index("unobs_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> unobs_reports(t);
        stan::math::initialize(unobs_reports, DUMMY_VAR__);
        stan::math::fill(unobs_reports, DUMMY_VAR__);
        stan::math::assign(unobs_reports,infections);
        current_statement_begin__ = 78;
        int delays(0);
        (void) delays;  // dummy to suppress unused var warning
        stan::math::fill(delays, std::numeric_limits<int>::min());
        stan::math::assign(delays,num_elements(delay_mean));
        current_statement_begin__ = 79;
        if (as_bool(delays)) {
            current_statement_begin__ = 80;
            for (int s = 1; s <= delays; ++s) {
                {
                current_statement_begin__ = 81;
                validate_non_negative_index("pmf", "get_base1(max_delay, s, \"max_delay\", 1)", get_base1(max_delay, s, "max_delay", 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(get_base1(max_delay, s, "max_delay", 1));
                stan::math::initialize(pmf, DUMMY_VAR__);
                stan::math::fill(pmf, DUMMY_VAR__);
                stan::math::assign(pmf,rep_vector(1e-5, get_base1(max_delay, s, "max_delay", 1)));
                current_statement_begin__ = 82;
                validate_non_negative_index("delay_indexes", "get_base1(max_delay, s, \"max_delay\", 1)", get_base1(max_delay, s, "max_delay", 1));
                std::vector<int  > delay_indexes(get_base1(max_delay, s, "max_delay", 1), int(0));
                stan::math::fill(delay_indexes, std::numeric_limits<int>::min());
                current_statement_begin__ = 83;
                for (int i = 1; i <= get_base1(max_delay, s, "max_delay", 1); ++i) {
                    current_statement_begin__ = 84;
                    stan::model::assign(delay_indexes, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(max_delay, s, "max_delay", 1) - i), 
                                "assigning variable delay_indexes");
                }
                current_statement_begin__ = 86;
                stan::math::assign(pmf, add(pmf, discretised_lognormal_pmf(delay_indexes, get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_sd, s, "delay_sd", 1), get_base1(max_delay, s, "max_delay", 1), pstream__)));
                current_statement_begin__ = 88;
                stan::math::assign(unobs_reports, convolve(unobs_reports, pmf, pstream__));
                }
            }
            current_statement_begin__ = 90;
            stan::math::assign(reports, stan::model::rvalue(unobs_reports, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "unobs_reports"));
        } else {
            current_statement_begin__ = 92;
            stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "infections"));
        }
        current_statement_begin__ = 94;
        return stan::math::promote_scalar<fun_return_scalar_t__>(reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_to_report_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const std::vector<T1__>& delay_mean,
                       const std::vector<T2__>& delay_sd,
                       const std::vector<int>& max_delay,
                       const int& seeding_time, std::ostream* pstream__) const {
        return convolve_to_report(infections, delay_mean, delay_sd, max_delay, seeding_time, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 99;
        int delays(0);
        (void) delays;  // dummy to suppress unused var warning
        stan::math::fill(delays, std::numeric_limits<int>::min());
        stan::math::assign(delays,num_elements(delay_mean));
        current_statement_begin__ = 100;
        if (as_bool(delays)) {
            current_statement_begin__ = 101;
            for (int s = 1; s <= delays; ++s) {
                current_statement_begin__ = 102;
                lp_accum__.add((normal_log(get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1)) * weight));
                current_statement_begin__ = 103;
                lp_accum__.add((normal_log(get_base1(delay_sd, s, "delay_sd", 1), get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1)) * weight));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct delays_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return delays_lp(delay_mean, delay_mean_mean, delay_mean_sd, delay_sd, delay_sd_mean, delay_sd_sd, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
day_of_week_effect(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 109;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 111;
        validate_non_negative_index("scaled_effect", "7", 7);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_effect(7);
        stan::math::initialize(scaled_effect, DUMMY_VAR__);
        stan::math::fill(scaled_effect, DUMMY_VAR__);
        stan::math::assign(scaled_effect,multiply(7, effect));
        current_statement_begin__ = 112;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 113;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 115;
            stan::model::assign(scaled_reports, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(reports, s, "reports", 1) * get_base1(scaled_effect, get_base1(day_of_week, s, "day_of_week", 1), "scaled_effect", 1)), 
                        "assigning variable scaled_reports");
        }
        current_statement_begin__ = 117;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct day_of_week_effect_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) const {
        return day_of_week_effect(reports, day_of_week, effect, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
scale_obs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 122;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 123;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 124;
        stan::math::assign(scaled_reports, multiply(reports, frac_obs));
        current_statement_begin__ = 125;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct scale_obs_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) const {
        return scale_obs(reports, frac_obs, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
truncation_cmf(const T0__& trunc_mean,
                   const T1__& trunc_sd,
                   const int& trunc_max, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 129;
        validate_non_negative_index("trunc_indexes", "trunc_max", trunc_max);
        std::vector<int  > trunc_indexes(trunc_max, int(0));
        stan::math::fill(trunc_indexes, std::numeric_limits<int>::min());
        current_statement_begin__ = 130;
        validate_non_negative_index("cmf", "trunc_max", trunc_max);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cmf(trunc_max);
        stan::math::initialize(cmf, DUMMY_VAR__);
        stan::math::fill(cmf, DUMMY_VAR__);
        current_statement_begin__ = 131;
        for (int i = 1; i <= trunc_max; ++i) {
            current_statement_begin__ = 132;
            stan::model::assign(trunc_indexes, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (i - 1), 
                        "assigning variable trunc_indexes");
        }
        current_statement_begin__ = 134;
        stan::math::assign(cmf, discretised_lognormal_pmf(trunc_indexes, trunc_mean, trunc_sd, trunc_max, pstream__));
        current_statement_begin__ = 135;
        stan::model::assign(cmf, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    (get_base1(cmf, 1, "cmf", 1) + 1e-8), 
                    "assigning variable cmf");
        current_statement_begin__ = 136;
        stan::math::assign(cmf, cumulative_sum(cmf));
        current_statement_begin__ = 137;
        stan::math::assign(cmf, reverse_mf(cmf, trunc_max, pstream__));
        current_statement_begin__ = 138;
        return stan::math::promote_scalar<fun_return_scalar_t__>(cmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_cmf_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& trunc_mean,
                   const T1__& trunc_sd,
                   const int& trunc_max, std::ostream* pstream__) const {
        return truncation_cmf(trunc_mean, trunc_sd, trunc_max, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
truncate(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const std::vector<T1__>& truncation_mean,
             const std::vector<T2__>& truncation_sd,
             const std::vector<int>& truncation_max,
             const int& reconstruct, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 143;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 144;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 145;
        validate_non_negative_index("trunc_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_reports(t);
        stan::math::initialize(trunc_reports, DUMMY_VAR__);
        stan::math::fill(trunc_reports, DUMMY_VAR__);
        stan::math::assign(trunc_reports,reports);
        current_statement_begin__ = 146;
        if (as_bool(truncation)) {
            {
            current_statement_begin__ = 148;
            int trunc_max(0);
            (void) trunc_max;  // dummy to suppress unused var warning
            stan::math::fill(trunc_max, std::numeric_limits<int>::min());
            stan::math::assign(trunc_max,(logical_gt(get_base1(truncation_max, 1, "truncation_max", 1), t) ? t : get_base1(truncation_max, 1, "truncation_max", 1) ));
            current_statement_begin__ = 149;
            validate_non_negative_index("trunc_indexes", "trunc_max", trunc_max);
            std::vector<int  > trunc_indexes(trunc_max, int(0));
            stan::math::fill(trunc_indexes, std::numeric_limits<int>::min());
            current_statement_begin__ = 150;
            validate_non_negative_index("cmf", "trunc_max", trunc_max);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cmf(trunc_max);
            stan::math::initialize(cmf, DUMMY_VAR__);
            stan::math::fill(cmf, DUMMY_VAR__);
            current_statement_begin__ = 151;
            int first_t(0);
            (void) first_t;  // dummy to suppress unused var warning
            stan::math::fill(first_t, std::numeric_limits<int>::min());
            stan::math::assign(first_t,((t - trunc_max) + 1));
            current_statement_begin__ = 152;
            stan::math::assign(cmf, truncation_cmf(get_base1(truncation_mean, 1, "truncation_mean", 1), get_base1(truncation_sd, 1, "truncation_sd", 1), trunc_max, pstream__));
            current_statement_begin__ = 154;
            if (as_bool(reconstruct)) {
                current_statement_begin__ = 155;
                stan::model::assign(trunc_reports, 
                            stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(elt_divide(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), cmf)), 
                            "assigning variable trunc_reports");
            } else {
                current_statement_begin__ = 157;
                stan::model::assign(trunc_reports, 
                            stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(elt_multiply(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), cmf)), 
                            "assigning variable trunc_reports");
            }
            }
        }
        current_statement_begin__ = 160;
        return stan::math::promote_scalar<fun_return_scalar_t__>(trunc_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncate_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const std::vector<T1__>& truncation_mean,
             const std::vector<T2__>& truncation_sd,
             const std::vector<int>& truncation_max,
             const int& reconstruct, std::ostream* pstream__) const {
        return truncate(reports, truncation_mean, truncation_sd, truncation_max, reconstruct, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 166;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 167;
        if (as_bool(truncation)) {
            current_statement_begin__ = 168;
            lp_accum__.add(normal_log<propto__>(truncation_mean, trunc_mean_mean, trunc_mean_sd));
            current_statement_begin__ = 169;
            lp_accum__.add(normal_log<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return truncation_lp(truncation_mean, truncation_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const int& phi_prior,
              const int& model_type,
              const T5__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T5__, T_lp__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 176;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        current_statement_begin__ = 177;
        if (as_bool(model_type)) {
            current_statement_begin__ = 179;
            lp_accum__.add(normal_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), 0, phi_prior));
            if (get_base1(rep_phi, model_type, "rep_phi", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0, phi_prior));
            current_statement_begin__ = 180;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
            current_statement_begin__ = 182;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 183;
                lp_accum__.add((poisson_log(cases, reports) * weight));
            } else {
                current_statement_begin__ = 185;
                lp_accum__.add((neg_binomial_2_log(cases, reports, sqrt_phi) * weight));
            }
        } else {
            current_statement_begin__ = 188;
            lp_accum__.add((poisson_log(cases, reports) * weight));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_lp_functor__ {
    template <typename T1__, typename T2__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const int& phi_prior,
              const int& model_type,
              const T5__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return report_lp(cases, reports, rep_phi, phi_prior, model_type, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
report_log_lik(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 194;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 195;
        validate_non_negative_index("log_lik", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(t);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 196;
        if (as_bool(model_type)) {
            {
            current_statement_begin__ = 198;
            local_scalar_t__ sqrt_phi(DUMMY_VAR__);
            (void) sqrt_phi;  // dummy to suppress unused var warning
            stan::math::initialize(sqrt_phi, DUMMY_VAR__);
            stan::math::fill(sqrt_phi, DUMMY_VAR__);
            stan::math::assign(sqrt_phi,(1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
            current_statement_begin__ = 200;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 201;
                for (int i = 1; i <= t; ++i) {
                    current_statement_begin__ = 202;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                                "assigning variable log_lik");
                }
            } else {
                current_statement_begin__ = 205;
                for (int i = 1; i <= t; ++i) {
                    current_statement_begin__ = 206;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (neg_binomial_2_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1), sqrt_phi) * weight), 
                                "assigning variable log_lik");
                }
            }
            }
        } else {
            current_statement_begin__ = 210;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 211;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                            "assigning variable log_lik");
            }
        }
        current_statement_begin__ = 214;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_log_lik_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) const {
        return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
    }
};
template <typename T0__, typename T1__, class RNG>
std::vector<int>
report_rng(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 218;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 219;
        validate_non_negative_index("sampled_reports", "t", t);
        std::vector<int  > sampled_reports(t, int(0));
        stan::math::fill(sampled_reports, std::numeric_limits<int>::min());
        current_statement_begin__ = 220;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        current_statement_begin__ = 221;
        if (as_bool(model_type)) {
            current_statement_begin__ = 222;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
            current_statement_begin__ = 223;
            for (int s = 1; s <= t; ++s) {
                current_statement_begin__ = 225;
                if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                    current_statement_begin__ = 226;
                    stan::model::assign(sampled_reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), base_rng__), 
                                "assigning variable sampled_reports");
                } else {
                    current_statement_begin__ = 228;
                    stan::model::assign(sampled_reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                neg_binomial_2_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), sqrt_phi, base_rng__), 
                                "assigning variable sampled_reports");
                }
            }
        } else {
            current_statement_begin__ = 232;
            for (int s = 1; s <= t; ++s) {
                current_statement_begin__ = 233;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), base_rng__), 
                            "assigning variable sampled_reports");
            }
        }
        current_statement_begin__ = 236;
        return stan::math::promote_scalar<fun_return_scalar_t__>(sampled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        std::vector<int>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) const {
        return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
calculate_secondary(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const std::vector<T3__>& delay_mean,
                        const std::vector<T4__>& delay_sd,
                        const std::vector<int>& max_delay,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 246;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 247;
        int obs_scale(0);
        (void) obs_scale;  // dummy to suppress unused var warning
        stan::math::fill(obs_scale, std::numeric_limits<int>::min());
        stan::math::assign(obs_scale,num_elements(frac_obs));
        current_statement_begin__ = 248;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 249;
        validate_non_negative_index("conv_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conv_reports(t);
        stan::math::initialize(conv_reports, DUMMY_VAR__);
        stan::math::fill(conv_reports, DUMMY_VAR__);
        stan::math::assign(conv_reports,rep_vector(1e-5, t));
        current_statement_begin__ = 250;
        validate_non_negative_index("secondary_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary_reports(t);
        stan::math::initialize(secondary_reports, DUMMY_VAR__);
        stan::math::fill(secondary_reports, DUMMY_VAR__);
        stan::math::assign(secondary_reports,rep_vector(0.0, t));
        current_statement_begin__ = 252;
        if (as_bool(obs_scale)) {
            current_statement_begin__ = 253;
            stan::math::assign(scaled_reports, scale_obs(reports, get_base1(frac_obs, 1, "frac_obs", 1), pstream__));
        } else {
            current_statement_begin__ = 255;
            stan::math::assign(scaled_reports, reports);
        }
        current_statement_begin__ = 258;
        stan::math::assign(conv_reports, add(conv_reports, convolve_to_report(scaled_reports, delay_mean, delay_sd, max_delay, 0, pstream__)));
        current_statement_begin__ = 262;
        for (int i = 1; i <= t; ++i) {
            current_statement_begin__ = 264;
            if (as_bool((primitive_value(cumulative) && primitive_value(logical_gt(i, 1))))) {
                current_statement_begin__ = 265;
                if (as_bool(logical_gt(i, predict))) {
                    current_statement_begin__ = 266;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(secondary_reports, (i - 1), "secondary_reports", 1), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 268;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(obs, (i - 1), "obs", 1), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 272;
            if (as_bool(historic)) {
                current_statement_begin__ = 273;
                if (as_bool(primary_hist_additive)) {
                    current_statement_begin__ = 274;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 276;
                    if (as_bool(logical_gt(get_base1(conv_reports, i, "conv_reports", 1), get_base1(secondary_reports, i, "secondary_reports", 1)))) {
                        current_statement_begin__ = 277;
                        stan::model::assign(conv_reports, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(secondary_reports, i, "secondary_reports", 1), 
                                    "assigning variable conv_reports");
                    }
                    current_statement_begin__ = 279;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 283;
            if (as_bool(current)) {
                current_statement_begin__ = 284;
                if (as_bool(primary_current_additive)) {
                    current_statement_begin__ = 285;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 287;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 290;
            stan::model::assign(secondary_reports, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (logical_lte(get_base1(secondary_reports, i, "secondary_reports", 1), 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-5) : stan::math::promote_scalar<local_scalar_t__>(get_base1(secondary_reports, i, "secondary_reports", 1)) ), 
                        "assigning variable secondary_reports");
        }
        current_statement_begin__ = 292;
        return stan::math::promote_scalar<fun_return_scalar_t__>(secondary_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct calculate_secondary_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const std::vector<T3__>& delay_mean,
                        const std::vector<T4__>& delay_sd,
                        const std::vector<int>& max_delay,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) const {
        return calculate_secondary(reports, obs, frac_obs, delay_mean, delay_sd, max_delay, cumulative, historic, primary_hist_additive, current, primary_current_additive, predict, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_simulate_secondary
  : public stan::model::model_base_crtp<model_simulate_secondary> {
private:
        int n;
        int t;
        int h;
        int all_dates;
        std::vector<int> obs;
        matrix_d primary;
        int seeding_time;
        int cumulative;
        int historic;
        int primary_hist_additive;
        int current;
        int primary_current_additive;
        int delays;
        std::vector<std::vector<double> > delay_mean;
        std::vector<std::vector<double> > delay_sd;
        std::vector<int> max_delay;
        std::vector<int> day_of_week;
        int week_effect;
        std::vector<std::vector<double> > day_of_week_simplex;
        int obs_scale;
        std::vector<std::vector<double> > frac_obs;
        int model_type;
        std::vector<std::vector<double> > rep_phi;
public:
    model_simulate_secondary(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_simulate_secondary(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_simulate_secondary_namespace::model_simulate_secondary";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 298;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 299;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 300;
            context__.validate_dims("data initialization", "h", "int", context__.to_vec());
            h = int(0);
            vals_i__ = context__.vals_i("h");
            pos__ = 0;
            h = vals_i__[pos__++];
            current_statement_begin__ = 301;
            context__.validate_dims("data initialization", "all_dates", "int", context__.to_vec());
            all_dates = int(0);
            vals_i__ = context__.vals_i("all_dates");
            pos__ = 0;
            all_dates = vals_i__[pos__++];
            current_statement_begin__ = 303;
            validate_non_negative_index("obs", "(t - h)", (t - h));
            context__.validate_dims("data initialization", "obs", "int", context__.to_vec((t - h)));
            obs = std::vector<int>((t - h), int(0));
            vals_i__ = context__.vals_i("obs");
            pos__ = 0;
            size_t obs_k_0_max__ = (t - h);
            for (size_t k_0__ = 0; k_0__ < obs_k_0_max__; ++k_0__) {
                obs[k_0__] = vals_i__[pos__++];
            }
            size_t obs_i_0_max__ = (t - h);
            for (size_t i_0__ = 0; i_0__ < obs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "obs[i_0__]", obs[i_0__], 0);
            }
            current_statement_begin__ = 304;
            validate_non_negative_index("primary", "n", n);
            validate_non_negative_index("primary", "t", t);
            context__.validate_dims("data initialization", "primary", "matrix_d", context__.to_vec(n,t));
            primary = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, t);
            vals_r__ = context__.vals_r("primary");
            pos__ = 0;
            size_t primary_j_2_max__ = t;
            size_t primary_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < primary_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < primary_j_1_max__; ++j_1__) {
                    primary(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 305;
            context__.validate_dims("data initialization", "seeding_time", "int", context__.to_vec());
            seeding_time = int(0);
            vals_i__ = context__.vals_i("seeding_time");
            pos__ = 0;
            seeding_time = vals_i__[pos__++];
            current_statement_begin__ = 306;
            context__.validate_dims("data initialization", "cumulative", "int", context__.to_vec());
            cumulative = int(0);
            vals_i__ = context__.vals_i("cumulative");
            pos__ = 0;
            cumulative = vals_i__[pos__++];
            current_statement_begin__ = 307;
            context__.validate_dims("data initialization", "historic", "int", context__.to_vec());
            historic = int(0);
            vals_i__ = context__.vals_i("historic");
            pos__ = 0;
            historic = vals_i__[pos__++];
            current_statement_begin__ = 308;
            context__.validate_dims("data initialization", "primary_hist_additive", "int", context__.to_vec());
            primary_hist_additive = int(0);
            vals_i__ = context__.vals_i("primary_hist_additive");
            pos__ = 0;
            primary_hist_additive = vals_i__[pos__++];
            current_statement_begin__ = 309;
            context__.validate_dims("data initialization", "current", "int", context__.to_vec());
            current = int(0);
            vals_i__ = context__.vals_i("current");
            pos__ = 0;
            current = vals_i__[pos__++];
            current_statement_begin__ = 310;
            context__.validate_dims("data initialization", "primary_current_additive", "int", context__.to_vec());
            primary_current_additive = int(0);
            vals_i__ = context__.vals_i("primary_current_additive");
            pos__ = 0;
            primary_current_additive = vals_i__[pos__++];
            current_statement_begin__ = 312;
            context__.validate_dims("data initialization", "delays", "int", context__.to_vec());
            delays = int(0);
            vals_i__ = context__.vals_i("delays");
            pos__ = 0;
            delays = vals_i__[pos__++];
            current_statement_begin__ = 313;
            validate_non_negative_index("delay_mean", "n", n);
            validate_non_negative_index("delay_mean", "delays", delays);
            context__.validate_dims("data initialization", "delay_mean", "double", context__.to_vec(n,delays));
            delay_mean = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_mean");
            pos__ = 0;
            size_t delay_mean_k_0_max__ = n;
            size_t delay_mean_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_mean_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
                    delay_mean[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 314;
            validate_non_negative_index("delay_sd", "n", n);
            validate_non_negative_index("delay_sd", "delays", delays);
            context__.validate_dims("data initialization", "delay_sd", "double", context__.to_vec(n,delays));
            delay_sd = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_sd");
            pos__ = 0;
            size_t delay_sd_k_0_max__ = n;
            size_t delay_sd_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_sd_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
                    delay_sd[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 315;
            validate_non_negative_index("max_delay", "delays", delays);
            context__.validate_dims("data initialization", "max_delay", "int", context__.to_vec(delays));
            max_delay = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("max_delay");
            pos__ = 0;
            size_t max_delay_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < max_delay_k_0_max__; ++k_0__) {
                max_delay[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 317;
            validate_non_negative_index("day_of_week", "(t - seeding_time)", (t - seeding_time));
            context__.validate_dims("data initialization", "day_of_week", "int", context__.to_vec((t - seeding_time)));
            day_of_week = std::vector<int>((t - seeding_time), int(0));
            vals_i__ = context__.vals_i("day_of_week");
            pos__ = 0;
            size_t day_of_week_k_0_max__ = (t - seeding_time);
            for (size_t k_0__ = 0; k_0__ < day_of_week_k_0_max__; ++k_0__) {
                day_of_week[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 318;
            context__.validate_dims("data initialization", "week_effect", "int", context__.to_vec());
            week_effect = int(0);
            vals_i__ = context__.vals_i("week_effect");
            pos__ = 0;
            week_effect = vals_i__[pos__++];
            current_statement_begin__ = 319;
            validate_non_negative_index("day_of_week_simplex", "n", n);
            validate_non_negative_index("day_of_week_simplex", "(week_effect ? 7 : 1 )", (week_effect ? 7 : 1 ));
            context__.validate_dims("data initialization", "day_of_week_simplex", "double", context__.to_vec(n,(week_effect ? 7 : 1 )));
            day_of_week_simplex = std::vector<std::vector<double> >(n, std::vector<double>((week_effect ? 7 : 1 ), double(0)));
            vals_r__ = context__.vals_r("day_of_week_simplex");
            pos__ = 0;
            size_t day_of_week_simplex_k_0_max__ = n;
            size_t day_of_week_simplex_k_1_max__ = (week_effect ? 7 : 1 );
            for (size_t k_1__ = 0; k_1__ < day_of_week_simplex_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < day_of_week_simplex_k_0_max__; ++k_0__) {
                    day_of_week_simplex[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t day_of_week_simplex_i_0_max__ = n;
            size_t day_of_week_simplex_i_1_max__ = (week_effect ? 7 : 1 );
            for (size_t i_0__ = 0; i_0__ < day_of_week_simplex_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < day_of_week_simplex_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "day_of_week_simplex[i_0__][i_1__]", day_of_week_simplex[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 320;
            context__.validate_dims("data initialization", "obs_scale", "int", context__.to_vec());
            obs_scale = int(0);
            vals_i__ = context__.vals_i("obs_scale");
            pos__ = 0;
            obs_scale = vals_i__[pos__++];
            current_statement_begin__ = 321;
            validate_non_negative_index("frac_obs", "n", n);
            validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
            context__.validate_dims("data initialization", "frac_obs", "double", context__.to_vec(n,obs_scale));
            frac_obs = std::vector<std::vector<double> >(n, std::vector<double>(obs_scale, double(0)));
            vals_r__ = context__.vals_r("frac_obs");
            pos__ = 0;
            size_t frac_obs_k_0_max__ = n;
            size_t frac_obs_k_1_max__ = obs_scale;
            for (size_t k_1__ = 0; k_1__ < frac_obs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
                    frac_obs[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 322;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            current_statement_begin__ = 323;
            validate_non_negative_index("rep_phi", "n", n);
            validate_non_negative_index("rep_phi", "model_type", model_type);
            context__.validate_dims("data initialization", "rep_phi", "double", context__.to_vec(n,model_type));
            rep_phi = std::vector<std::vector<double> >(n, std::vector<double>(model_type, double(0)));
            vals_r__ = context__.vals_r("rep_phi");
            pos__ = 0;
            size_t rep_phi_k_0_max__ = n;
            size_t rep_phi_k_1_max__ = model_type;
            for (size_t k_1__ = 0; k_1__ < rep_phi_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
                    rep_phi[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t rep_phi_i_0_max__ = n;
            size_t rep_phi_i_1_max__ = model_type;
            for (size_t i_0__ = 0; i_0__ < rep_phi_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rep_phi_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "rep_phi[i_0__][i_1__]", rep_phi[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_simulate_secondary() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sim_secondary");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back((all_dates ? t : h ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_simulate_secondary_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 327;
            validate_non_negative_index("sim_secondary", "n", n);
            validate_non_negative_index("sim_secondary", "(all_dates ? t : h )", (all_dates ? t : h ));
            std::vector<std::vector<int> > sim_secondary(n, std::vector<int>((all_dates ? t : h ), int(0)));
            stan::math::fill(sim_secondary, std::numeric_limits<int>::min());
            // generated quantities statements
            current_statement_begin__ = 328;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 329;
                validate_non_negative_index("secondary", "t", t);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary(t);
                stan::math::initialize(secondary, DUMMY_VAR__);
                stan::math::fill(secondary, DUMMY_VAR__);
                current_statement_begin__ = 331;
                stan::math::assign(secondary, calculate_secondary(to_vector(get_base1(primary, i, "primary", 1)), obs, get_base1(frac_obs, i, "frac_obs", 1), get_base1(delay_mean, i, "delay_mean", 1), get_base1(delay_sd, i, "delay_sd", 1), max_delay, cumulative, historic, primary_hist_additive, current, primary_current_additive, ((t - h) + 1), pstream__));
                current_statement_begin__ = 337;
                if (as_bool(week_effect)) {
                    current_statement_begin__ = 338;
                    stan::math::assign(secondary, day_of_week_effect(secondary, day_of_week, to_vector(get_base1(day_of_week_simplex, i, "day_of_week_simplex", 1)), pstream__));
                }
                current_statement_begin__ = 341;
                stan::model::assign(sim_secondary, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            report_rng(tail(secondary, (all_dates ? t : h )), get_base1(rep_phi, i, "rep_phi", 1), model_type, base_rng__, pstream__), 
                            "assigning variable sim_secondary");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 327;
            size_t sim_secondary_k_0_max__ = n;
            size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
            for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                    vars__.push_back(sim_secondary[k_0__][k_1__]);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_simulate_secondary";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = n;
        size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
        for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = n;
        size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
        for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_simulate_secondary_namespace::model_simulate_secondary stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
