% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_regional_results}
\alias{get_regional_results}
\title{Get Combined Regional Results}
\usage{
get_regional_results(
  regional_output,
  results_dir,
  date,
  samples = TRUE,
  forecast = FALSE
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{regional_epinow} and stored in the
\code{regional} list.}

\item{results_dir}{A character string indicating the folder containing the \code{EpiNow2}
results to extract.}

\item{date}{A Character string (in the format "yyyy-mm-dd") indicating the date to extract
data for. Defaults to "latest" which finds the latest results available.}

\item{samples}{Logical, defaults to \code{TRUE}. Should samples be returned.}

\item{forecast}{Logical, defaults to \code{FALSE}. Should forecast results be returned.}
}
\value{
A list of estimates, forecasts and estimated cases by date of report.
}
\description{
Get Combined Regional Results
}
\examples{
\donttest{
# construct example distributions
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- EpiNow2::bootstrapped_dist_fit(rlnorm(100, log(6), 1), max_value = 30)

# example case vector from EpiSoon
cases <- EpiNow2::example_confirmed[1:30]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
  
# run multiregion estimates
regional_out <- regional_epinow(reported_cases = cases,
                                samples = 100,
                                generation_time = generation_time,
                                delays = list(incubation_period, reporting_delay),
                                stan_args = list(warmup = 100,
                                                 cores = ifelse(interactive(), 4, 1)),
                                output = c("regions"))

summary_only <- get_regional_results(regional_out$regional, forecast = FALSE, samples = FALSE)
names(summary_only)

all <- get_regional_results(regional_out$regional, forecast = TRUE)
names(all)
}
}
