% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{set_network}
\alias{set_network}
\alias{set_network.netsim_dat}
\title{Set Network State During netsim Simulation}
\usage{
set_network(x, ...)

\method{set_network}{netsim_dat}(x, network = 1L, nw, ...)
}
\arguments{
\item{x}{a \code{netsim_dat} object}

\item{network}{the index of the network to set on \code{x}}

\item{nw}{the value of the network to set on \code{x}}
}
\value{
the \code{netsim_dat} object with the network state updated
}
\description{
This function updates the \code{netsim_dat} object given a
network representing the current state of the simulation.
}
\details{
If running \code{tergmLite} simulation, this function updates
\code{x$el[[network]]} and (if \code{tergmLite.track.duration} is \code{TRUE}
for the network index \code{network}) the network attributes \code{"time"}
and \code{"lasttoggle"} in \code{x$net_attr[[network]]}. If not running
\code{tergmLite} simulation, this function updates the \code{networkDynamic}
object stored in \code{x$nw[[network]]}. The input \code{nw} should be of
class \code{networkLite} when running \code{tergmLite} simulation, and of
class \code{networkDynamic} when not running \code{tergmLite} simulation.
}
\keyword{internal}
\keyword{netUtils}
