% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{get_cumulative_edgelists_df}
\alias{get_cumulative_edgelists_df}
\title{Get the Cumulative Edgelists of a Model}
\usage{
get_cumulative_edgelists_df(dat, networks = NULL)
}
\arguments{
\item{dat}{Main list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{networks}{Numerical indexes of the networks to extract the partnerships
from. (May be > 1 for models with multiple overlapping
networks.) If \code{NULL}, extract from all networks.}
}
\value{
A \code{data.frame} with 5 columns:
\itemize{
  \item \code{index}: the unique ID (see \code{get_unique_ids}) of the
        indexes.
  \item \code{partner}: the unique ID (see \code{get_unique_ids}) of the
        partners/contacts.
  \item \code{start}: the time step in which the edge started.
  \item \code{stop}: the time step in which the edge stopped; if ongoing,
        then \code{NA} is returned.
  \item \code{network}: the numerical index for the network on which the
        partnership/contact is located.
 }
}
\description{
Get the Cumulative Edgelists of a Model
}
