% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcm.inputs.R
\name{init.dcm}
\alias{init.dcm}
\title{Initial Conditions for Deterministic Compartmental Models}
\usage{
init.dcm(s.num, i.num, r.num, s.num.g2, i.num.g2, r.num.g2, ...)
}
\arguments{
\item{s.num}{Number of initial susceptible. For two-group models, this is
the number of initial group 1 susceptible.}

\item{i.num}{Number of initial infected. For two-group models, this is the
number of initial group 1 infected.}

\item{r.num}{Number of initial recovered. For two-group models, this is the
number of initial group 1 recovered. This parameter is only used for
the \code{SIR} model type.}

\item{s.num.g2}{Number of initial susceptible in group 2. This parameter is
only used for two-group models.}

\item{i.num.g2}{Number of initial infected in group 2. This parameter is only
used for two-group models.}

\item{r.num.g2}{Number of initial recovered in group 2. This parameter is
only used for two-group \code{SIR} models.}

\item{...}{Additional initial conditions passed to model.}
}
\description{
Sets the initial conditions for deterministic compartmental
             models simulated with \code{dcm}.
}
\details{
The initial conditions for a model solved with \code{\link{dcm}} should be
input into the \code{init.dcm} function. This function handles initial
conditions for both base model types and original models. For an overview
of initial conditions for base DCM class models, consult the
\href{http://epimodel.org/tut.html}{Basic DCMs} tutorial.

Original models may use the parameter names listed as arguments here, a new
set of names, or a combination of both. With new models, initial conditions
must be input in the same order that the solved derivatives from the model
are output. More details on this requirement are outlined in the
\href{http://epimodel.org/tut.html}{Solving New DCMs} tutorial.
}
\seealso{
Use \code{\link{param.dcm}} to specify model parameters and
         \code{\link{control.dcm}} to specify the control settings. Run the
         parameterized model with \code{\link{dcm}}.
}
\keyword{parameterization}
