% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mutate_epi}
\alias{mutate_epi}
\title{Add New Epidemiology Variables}
\usage{
mutate_epi(sim, ...)
}
\arguments{
\item{sim}{An object of class \code{netsim}.}

\item{...}{Name-value pairs of expressions (see examples below).}
}
\value{
An object of class \code{netsim} with the additional variables.
}
\description{
Inspired by \code{dplyr::mutate}, \code{mutate_epi} adds new 
             variables to the epidemiological and related variables within 
             an object of class \code{netsim}.
}
\examples{
nw <- network.initialize(n = 100, bipartite = 50, directed = FALSE)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est1 <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

# Epidemic model
param <- param.net(inf.prob = 0.3, inf.prob.m2 = 0.15)
init <- init.net(i.num = 1, i.num.m2 = 0)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, 
                       verbose = FALSE)
mod1 <- netsim(est1, param, init, control)
mod1

# Add the prevalences to the dataset
mod1 <- mutate_epi(mod1, i.prev = i.num / num,
                         i.prev.m2 = i.num.m2 / num.m2)
plot(mod1, y = c("i.prev", "i.prev.m2"), qnts = 0.5, leg = TRUE)                        
                         
# Add incidence rate per 100 person years (assume time step = 1 week)
mod1 <- mutate_epi(mod1, ir100 = 5200*(si.flow + si.flow.m2) / 
                                      (s.num + s.num.m2))       
df <- as.data.frame(mod1)
df$ir100

}

