% Generated by roxygen2 (4.0.1): do not edit by hand
\name{as.data.frame.dcm}
\alias{as.data.frame.dcm}
\title{Extract Model Data for Deterministic Compartmental Models}
\usage{
\method{as.data.frame}{dcm}(x, row.names = NULL, optional = FALSE,
  run = 1, ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{\link{dcm}}.}

\item{run}{run number for model; used for multiple-run sensitivity models.}

\item{row.names}{see \code{\link{as.data.frame.default}}.}

\item{optional}{see \code{\link{as.data.frame.default}}.}

\item{...}{see \code{\link{as.data.frame.default}}.}
}
\description{
This function extracts a model run from an object of class
             \code{dcm} into a data frame using the generic
             \code{as.data.frame} function.
}
\details{
Model output from a \code{dcm} simulation are available as a data
frame with this helper function. The output data frame will include
columns for time, the size of each compartment, the overall population
size (the sum of compartment sizes), and the size of each flow.
}
\examples{
## Example 1: One-group SIS model with varying act.rate
param <- param.dcm(trans.rate = 0.2, act.rate = seq(0.05, 0.5, 0.05),
                   rec.rate = 1/50)
init <- init.dcm(s.num = 500, i.num = 1)
control <- control.dcm(type = "SIS", nsteps = 500)
mod1 <- dcm(param, init, control)
head(as.data.frame(mod1, run = 1))
head(as.data.frame(mod1, run = 10))

## Example 2: Two-group SIR model with vital dynamics
param <- param.dcm(trans.rate = 0.2, trans.rate.g2 = 0.1,
                   act.rate = 3, balance = "g1",
                   rec.rate = 1/50, rec.rate.g2 = 1/50,
                   b.rate = 1/100, b.rate.g2 = NA,
                   ds.rate = 1/100, ds.rate.g2 = 1/100,
                   di.rate = 1/90, di.rate.g2 = 1/90,
                   dr.rate = 1/100, dr.rate.g2 = 1/100)
init <- init.dcm(s.num = 500, i.num = 1, r.num = 0,
                 s.num.g2 = 500, i.num.g2 = 1, r.num.g2 = 0)
control <- control.dcm(type = "SIR", nsteps = 500)
mod2 <- dcm(param, init, control)
head(as.data.frame(mod2))
tail(as.data.frame(mod2))
}
\keyword{extract}

