% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulateMaxSprtData}
\alias{simulateMaxSprtData}
\title{Simulate survival data for MaxSPRT computation}
\usage{
simulateMaxSprtData(
  n = 10000,
  pExposure = 0.5,
  backgroundHazard = 0.001,
  tar = 10,
  nullMu = 0.2,
  nullSigma = 0.2,
  maxT = 100,
  looks = 10,
  numberOfNegativeControls = 50,
  numberOfPositiveControls = 1,
  positiveControlEffectSize = 4
)
}
\arguments{
\item{n}{Number of subjects.}

\item{pExposure}{Probability of being in target cohort.}

\item{backgroundHazard}{Background hazard (risk of the outcome per day).}

\item{tar}{Time at risk for each exposure}

\item{nullMu}{Null distribution mean (at log HR scale)}

\item{nullSigma}{Null distribution SD (at log HR scale)}

\item{maxT}{Maximum time to simulate.}

\item{looks}{Number of (evenly spaced) looks at the data.}

\item{numberOfNegativeControls}{Number of negative controls to simulate.}

\item{numberOfPositiveControls}{Number of positive controls to simulate.}

\item{positiveControlEffectSize}{The true effect size of the positive controls.}
}
\value{
A data frame with 5 variables: \describe{ \item{time}{Time from index date to either the event or 
end of observation, whichever came first} \item{outcome}{Whether the outcome occurred (1) or not (0)} \item{exposure}{Whether 
the subject was exposed (TRUE) or not (FALSE)} \item{lookTime}{The time point when the look occurred. } \item{outcomeId}{A unique 
identifier for data corresponding to a single outcome. Lower IDs indicate negative controls, higher IDs indicate the positive control} }
}
\description{
Simulate survival data for MaxSPRT computation
}
\details{
Simulate survival data for negative and positive controls. The data provides multiple looks at data accruing over time, with 
each look having more data than the one before. Systematic error for each outcome is drawn from the prespecified null distribution.

The outcome IDs are assigned sequentially starting at 1, with the first IDs used for the negative controls, and the latter IDs used
for the positive controls.
}
\examples{
data <- simulateMaxSprtData(n = 1000)
head(data)

}
