% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mml.scoreTIMSS.R
\name{scoreTIMSS}
\alias{scoreTIMSS}
\title{EdSurvey Direct Estimation - TIMSS scoring}
\usage{
scoreTIMSS(edf, polyParamTab, dichotParamTab, scoreCard = NULL)
}
\arguments{
\item{edf}{a TIMSS \code{light.edsurvey.data.frame} or \code{edsurvey.data.frame}}

\item{polyParamTab}{a dataframe containing IRT parameters for all polytomous items in \code{edf}}

\item{dichotParamTab}{a dataframe containing IRT parameters for all dichotomous items in \code{edf}}

\item{scoreCard}{unused}
}
\value{
scored \code{edf}
}
\description{
Scoring TIMSS data
}
\details{
This function scores TIMSS data.
For multiple choice items, correct answers are assigned 1 point, and incorrect answers are assigned 0 points.
For constructed response items, correct answers are assigned 2 points, partially correct answers are assigned 1 point,
and incorrect answers are assigned 0 points. For both types of items, "NOT REACHED" and "OMITTED OR INVALID" are assigned 0 points.
these defaults can be changed by modifying the \code{scoreDict} columns \code{pointMult} and \code{pointConst}, respectively.
}
