% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showWeights.R
\name{isWeight}
\alias{isWeight}
\title{Weight Test}
\usage{
isWeight(var, data)
}
\arguments{
\item{var}{a character vector of variables}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}
}
\value{
a logical vector of values indicating if each element of \code{var}
        is a weight
}
\description{
Returns logical values indicating whether a vector of variables is a weight for an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\details{
Note that this function returns \code{TRUE} only when the \code{var} element is the name of the weight used
         for making estimates but not if it is one of the individual jackknife replicates.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# TRUE
isWeight(var="origwt", data=sdf)

# FALSE
isWeight(var="dsex", data=sdf)
}
}
\author{
Michael Lee and Paul Bailey
}
