% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPISA.R
\name{downloadPISA}
\alias{downloadPISA}
\title{Download and Unzips PISA Files}
\usage{
downloadPISA(year = "*", database = "INT", root, cache = FALSE,
  verbose = TRUE)
}
\arguments{
\item{year}{the assessment years to download. Available years are 2000, 2003,
2006, 2009, and 2012. To download data for all available years,
users can input \code{*} (the default).}

\item{database}{a character to indicate which database to download from. For 2012,
three databases are available (INT = International, CBA = Computer-Based Assessment, and
FIN = Financial Literacy). Defaults to \code{INT}.}

\item{root}{a character string indicating the directory where the PISA data should
be stored. Note that files are placed in a folder named PISA and then in
a year subdirectory.}

\item{cache}{a logical value set to \code{FALSE} to cache .txt versions of files. If set to \code{TRUE}, the function will
process all downloaded files, which might take several hours.}

\item{verbose}{a logical value that determines if you want verbose output while the function is running to indicate the progress.
Defaults to \code{TRUE}.}
}
\description{
Uses a connection to download PISA data to a
             computer. Data come from the OECD website.
}
\author{
Trang Nguyen
}
