% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGEcotone.R
\name{ggEcotone}
\alias{ggEcotone}
\title{GGplot method for EcotoneFinder}
\usage{
ggEcotone(ecotonefinder, slope = NULL, plot.data = FALSE,
  method = c("none", "dca", "fanny", "vegclust", "cmeans", "diversity",
  "dca_slope", "fanny_slope", "vegclust_slope", "cmeans_slope",
  "diversity_slope"), axis.number = 1, diversity = c("Shannon",
  "SpeciesRichness", "ExpShannon", "Pielou", "SpeciesRichness_slope",
  "Shannon_slope", "ExpShannon_slope", "Pielou_slope"), facet = NULL,
  col = "black", title = NULL, xlab = NULL, ylab = NULL,
  return.plot = TRUE)
}
\arguments{
\item{ecotonefinder}{list containing elements named in the same way than the
EcotoneFinder function outcomes.}

\item{slope}{list containing elements named in the same way than the Slope
function outcomes.}

\item{plot.data}{Logical. Should the data be plotted? Default to FALSE.}

\item{method}{Analysis method to be plotted from the EcotoneFinder results or
the Slope results. Must be one or several of
"none","dca","fanny","vegclust", "cmeans","diversity",
"dca_slope","fanny_slope","vegclust_slope", "cmeans_slope" or
"diversity_slope".}

\item{axis.number}{Number of DCA axis to be plotted. Must be between 1 and 4.
Default to 1.}

\item{diversity}{diversity indice to be plotted, if the method argument
contains "diversity" or "diversity_slope". Must be one or several of "Shannon",
"SpeciesRichness", "ExpShannon", "Pielou", "all"}

\item{facet}{Character vector of method names indicating how the plot should
be facetted. Can be provided as a list if several methods are to be plotted
on the same facets. Can contain "data" if plot.data = T. If NULL, no facets
are returned. See details.}

\item{col}{Color palette to be used for plotting. Must be either of length 1,
of the same lenght than the number of facets (when provided), or of the same
length than the number of species (if plot.data = TRUE), or than the number
of groups or axis plotted with the method argument. See details.}

\item{title}{Main title for the plot}

\item{xlab}{A title for the x-axis. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{return.plot}{Logical. If TRUE, the plot is directly plotted. If FALSE,
the plot is stored as a ggplot object. Default to FALSE. See details.}
}
\value{
A ggplot object.
}
\description{
GGplot method for EcotoneFinder
}
\details{
The ggEcotone function is intended to facilitate the plotting of
  EcotoneFinder lists with the use of the ggplot2 grammar. It either directly
  print its outputs (if plot = TRUE), or returns a ggplot object that can be
  further modified (if plot = FALSE). The latter allows for the addition of
  other ggplot2 layers to personalise graphical outputs (see examples).

  Facetting options are implemented to allow for the separation of the
  different method outputs and facilitate comparisons. The facet parameter
  accepts lists, with each element of the list corresponding to a facet and
  consisting of the names of the methods to be plotted on that facet.

  The col parameter allows for basic control over the colors of the lines.
  ggplot internally recycles colour vectors for each new facets, making it
  difficult to precisely control colours in facetted plots. Plotting the
  outputs on several graphs and arranging them on a grid is the best way to
  produce "facetted" plots with different coulour schemes. See examples.
}
\examples{
#### Artificial dataset:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL ,Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.015,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 ## Analyses:
 EcoFinder <- EcotoneFinder(data = SyntheticTrial[,-1],
                            dist = SyntheticTrial$Distance,
                            method = "all", groups = 3,
                            standardize = "hellinger", diversity = "all")

 ## Slope calculation:
 EcoSlope <- Slope(EcoFinder, method = "all", axis.number = 2,
                   diversity = "all")

 ## Plots:
 \donttest{
 require(ggplot2)
 require(colorspace)
 # Species Distributions and Fuzzy clusters:
 Plot <- ggEcotone(EcoFinder, slope = EcoSlope, plot.data = TRUE,
                   method = c("cmeans", "fanny"),
                   col = c("#D33F6A", "#E99A2C", "#E2E6BD"),
                   facet = list(c("data"), c("cmeans", "fanny")),
                   title = "Species distribution and fuzzy clusters",
                   xlab = "Gradient", ylab = "Membership grades") +
   theme(plot.title = element_text(hjust = 0.5, face="bold")) +
   theme_bw()
 Plot

 # Fuzzy clusters & derivatives:
 Plot <- ggEcotone(EcoFinder, slope = EcoSlope, plot.data = FALSE,
                   method = c("cmeans", "cmeans_slope"),
                   col = c("#D33F6A", "#E99A2C", "#E2E6BD"),
                   facet = c("cmeans", "cmeans_slope"),
                   title = "fuzzy clusters and derivatives",
                   xlab = "Gradient", ylab = "Membership grades") +
   theme(plot.title = element_text(hjust = 0.5, face="bold")) +
   theme_bw()
 Plot

 # Multiplot layout:
 GG1 <- ggEcotone(EcoFinder, slope = EcoSlope, plot.data = TRUE,
                  method = c("none"), col = heat_hcl(21), facet = NULL,
                  title = "Species distributions", xlab = NULL,
                  ylab = "Abundances") +
   theme(plot.title = element_text(hjust = 0.5, face="bold")) +
   theme_bw()

 GG2 <- ggEcotone(EcoFinder, slope = EcoSlope, plot.data = FALSE,
                  method = c("cmeans"), col = c("#023FA5", "#BEC1D4", "#D6BCC0"),
                  facet = NULL, title = "Fuzzy clusters", xlab = NULL,
                  ylab = "Membership grades") +
   theme(plot.title = element_text(hjust = 0.5, face="bold")) +
   theme_bw()

 GG3 <- ggEcotone(EcoFinder, slope = EcoSlope, plot.data = FALSE,
                  method = c("diversity"),
                  col = c("#26A63A", "#B4B61A"), facet = NULL,
                  diversity=c("SpeciesRichness", "ExpShannon"),
                  title = "diversity indices", xlab = "Gradient",
                  ylab = "Index scores") +
   theme(plot.title = element_text(hjust = 0.5, face="bold")) +
   theme_bw()

 require(Rmisc)
 Rmisc::multiplot(GG1,GG2,GG3)
 }

}
