% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Synthetic_Data.R
\name{SyntheticDataSeries}
\alias{SyntheticDataSeries}
\title{Synthetic data for Space/Time series}
\usage{
SyntheticDataSeries(CommunityPool, CommunityNum, Length = 100,
  SpCo = NULL, SeriesNum, replacement = TRUE,
  range.repl = as.integer(CommunityPool/5), Parameters = list(a = NULL,
  b = NULL, c = NULL), Parameters.repl = TRUE, dev.a = 10,
  dev.b = 10, dev.c = 0, Parameters.range = 10,
  displacement = NULL, pal = NULL, xlab = "Gradient",
  ylab = "Synthetic species", title = "Synthetic data")
}
\arguments{
\item{CommunityPool}{Total number of species per series. must either be of
length 1 (if the pool of species is of the same length for all communities)
or of length equal to CommunityNum (specifying the species pool for each
community)}

\item{CommunityNum}{An integer giving the number of communities.}

\item{Length}{The lenght of the gradient. Corresponds to the x-axis in a
plot.}

\item{SpCo}{The ratio of species per communities. When replacement = T, SpCo
is computed from CommunityPool and range.repl.}

\item{SeriesNum}{The number of series to be synthetised.}

\item{replacement}{Logical. Should the species of a community in a given
series be a sample of the possible number of species in this community. See
Details.}

\item{range.repl}{An integer. Gives the possible range of species turnover in
a community.}

\item{Parameters}{A list containing the parameters (a, b and c) for the
gaussians. Each parameter must be specified for each community. See
Details.}

\item{Parameters.repl}{Logical. Sould the parameters vary between series.}

\item{dev.a}{The deviation around parameter a for the gaussian in a
community. If 0 all species curve in the comunity will have the same a
parameter.}

\item{dev.b}{The deviation around parameter b for the gaussian in a
community. If 0 all species curve in the comunity will have the same b
parameter.}

\item{dev.c}{The deviation around parameter a for the gaussian in c
community. If 0 all species curve in the comunity will have the same c
parameter.}

\item{Parameters.range}{An integer. Gives the possible range of the parameter
variations between two series. The range of variation is the parameter
diveded by the parameters range. Default is 10.}

\item{displacement}{Numeric matrix to control the direction of the changes in
the mean values of the parameters over the series. See examples.}

\item{pal}{The color palette to be used. Species curves are colored according
to communities.}

\item{xlab}{A title for the x-axis. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{title}{An overall title for the plot. See plot.}
}
\value{
SyntheticDataSeries returns a list of datasets with numbered species
  (sp.1, sp.2, ...) as columns. The list has length = SeriesNum. It also plot
  the obtained data.
}
\description{
Synthetic data for Space/Time series
}
\details{
SyntheticDataSeries is a extention of the SyntheticData function and
  intended to produce easy and consistent space/time series of artificial
  ecological community datasets. The series of dataframes are stored in an
  object of class list. The replacement and Parameters.repl arguments allow
  the user to choose wether or not the number of species and their
  distribution curves should vary among the different series. range.repl is
  an integer that define the boundaries  of the interval in which the number
  of species can vary - such as the number of species per community is :
  \emph{sample([[CommunityPool/CommunityNum - range.repl ;
  CommunityPool/CommunityNum + range.repl]])} The number it takes is then
  used to define SpCo. Given the difference of scales between the 3
  parameters a, b and c, the Parameters.range argument controls the
  variations of the parameters by divison so that they correspond to :
  \emph{sample([[Parameters - Parameters/Parameters.range ; Parameters +
  Parameters/Parameters.range]])} The obtained parameters are then used by
  the internal SyntheticData function as base parameters for a given series,
  on which dev.a, dev.b and dev.c will apply. The other arguments are
  equivalent to those of SyntheticData.
}
\examples{
##### 5 datasets of 40 species spread on 4 communities without turnover
##### on the number of species nor variations in their distribution:

SyntheticTrialSeries <- SyntheticDataSeries(CommunityPool = 40,
                                            CommunityNum = 4, SpCo = NULL,
                                            Length = 500, SeriesNum = 5,
                                            Parameters = list(a=rep(60, 4),
                                                              b=c(0,200,350,500),
                                                              c=rep(0.03,4)),
                                            pal = c("#008585", "#B8CDAE", "#E6C186", "#C7522B"),
                                            replacement = FALSE,
                                            Parameters.repl = FALSE)

##### 5 datasets of 40 species spread on 4 communities with species turnover
##### and variations in their distributions along the gradient:

SyntheticTrialSeries <- SyntheticDataSeries(CommunityPool = 40,
                                            CommunityNum = 4, SpCo = NULL,
                                            Length = 500, SeriesNum = 5,
                                            Parameters = list(a=rep(60, 4),
                                                              b=c(0,200,350,500),
                                                              c=rep(0.03,4)),
                                            pal = c("#008585", "#B8CDAE", "#E6C186", "#C7522B"),
                                            replacement = TRUE,
                                            Parameters.repl = TRUE)

##### With a displacement matrix to control the direction of the changes
##### between series:

# Dispalcement matrix (Parameters x Communities):
disp <- matrix(data=c(0,0,0,
                      0,35,-0.0007,
                      0,10,0), nrow = 3, ncol = 3)

Series <- SyntheticDataSeries(CommunityPool = 60, CommunityNum = 3, Length = 500,
                               SeriesNum = 5, replacement = FALSE, SpCo = c(15,15,30),
                               Parameters = list(a = c(60,60,60),
                                                 b = c(-50,-50,400),
                                                 c = c(0.01, 0.01, 0.01)),
                               dev.a=30, dev.b=40, dev.c=0,
                               displacement = disp,
                               pal = c(rep("#008585",15), rep("#FBF2C4",15),
                                       rep("#C7522B",30)))

}
