% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim7}
\alias{sim7}
\title{Sim7 Co-occurrence Randomization Algorithm}
\usage{
sim7(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and fill as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling all
elements. Columns are equiprobable, and rows are proportional to row sums.
Makes a call to the vector_sample function.
}
\details{
This algorithm assumes that sites are equiprobable, but that
differences in frequency of occurrence among species are proportional to
observed species richness (=colsums).
}
\note{
This algorithm assumes that species are equiprobable, and that
differences among sites are proportional to observed species richness
(=colsums). sim7 has a high frequency of Type I errors with random matrices,
so it is not recommended for co-occurrence analysis.
}
\examples{
randomMatrix <- sim7(speciesData = matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.
}

