% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{pianka}
\alias{pianka}
\title{Pianka Niche Overlap Metric}
\usage{
pianka(m = matrix(rpois(80, 1), nrow = 10))
}
\arguments{
\item{m}{a matrix of resource utilization values.}
}
\value{
Returns the average pairwise niche overlap.
}
\description{
Takes a resource utilization matrix as input and
returns the average pairwise Pianka's niche overlap index.
}
\details{
Pianka's niche overlap index is averaged
over each unique species pair. The index is symmetric,
with a normalization term in the denominator for the overlap
between species 1 and 2. Values of Pianka's niche overlap index close to 0.0
reflect usage of exclusive resource categories, whereas values close to 1.0
reflect similar resource utilization spectra.
\deqn{O_{jk} = O_{kj} = \frac{\sum_{n}^{i}p_{ij}p_{jk}}{\sqrt{\sum_{n}^{i}p_{ij}^2\sum_{n}^{i}p_{ik}^2}}}{O_jk = O_kj = sum(p_ij*p_jk) / sqrt(sum((p_ij)^2)sum((p_jk)^2))}
}
\note{
The resource utilization matrix (rows = species, columns = discrete
resource categories) may include zeroes, but no negative numbers or missing
values. Relative resource within a species is first calculated, so the rows
need not sum to 1.0.
}
\examples{
obsOverlap <- pianka(m=matrix(rpois(40,0.5),nrow=8))
}
\references{
Pianka, E. 1973. The structure of lizard communities.
Annual Review of Ecology and Systematics 4:53-74.

Winemiller, K.O. and E.R. Pianka. 1990. Organization in natural assemblages
of desert lizards and tropical fishes. Ecological Monographs 60: 27-55.
}
\seealso{
\code{\link{czekanowski}} niche overlap index.
}

