% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{czekanowski_skew}
\alias{czekanowski_skew}
\title{CzekanowskiSkew Niche Overlap Metric}
\usage{
czekanowski_skew(m = matrix(rpois(80, 1), nrow = 10))
}
\arguments{
\item{m}{a matrix of resource utilization values.}
}
\value{
Returns the skewness of the average pairwise niche overlap.
}
\description{
Takes a niche utilization matrix returns the skew of the
Czekanowski pairwise niche overlap index.
}
\details{
A large positive value for skewness implies that there are more species pairs
with high than low niche overlap. A large negative  value for skewness implies there are more
species pairs with low than high niche overlap. The performance of this algorithm
has not been thoroughly tested with real data sets.
}
\note{
The resource utilization matrix (rows = species, columns = discrete
resource categories) may include zeroes, but no negative numbers or missing
values. Relative resource within a species is first calculated, so the rows
need not sum to 1.0.
}
\examples{
obsSkew <- czekanowski_skew(m=matrix(rpois(40,0.5),nrow=8))
}
\references{
Winemiller, K.O. and E.R. Pianka. 1990. Organization in natural assemblages
of desert lizards and tropical fishes. Ecological Monographs 60: 27-55.
}
\seealso{
\code{\link{czekanowski}} niche overlap index.
}

