% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.formula.R
\name{eco.formula}
\alias{eco.formula}
\title{Conversion of a formula for an ecogen objects into an explict expression}
\usage{
eco.formula(eco, formula, out.mode = c("formula", "expression"),
  expand.tables = "+")
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{formula}{formula with names of colums from the slots XY, P, G, A, E, or C}

\item{out.mode}{Output results explicit formula (default) or expression.}

\item{expand.tables}{method for tables coertion. Default is "+"}
}
\description{
The function creates an explicit formula that can be used as input 
to parse ecogen objects into other methods. For this purpose, each element in the 
formula is substituted with an explicit name of columns in ecogen objects if:

- The name in formula corresponds to the name of a column in the data frames of the object, or
- The name in formula is surrounded by U() and corresponds to a slot name. Complete data frames (as P, E, etc) 
  or subsets (as U[, 1:5]) can be passed with this method.
  
  In other situations, text is not replaced.
}
\examples{
\dontrun{
require(vegan)
data(eco.test)

# Note that in this example "Condition" is not replaced; 
# the function Condition has a special meaning in rda,
# indicating conditioning variables; in eco.formula it is only text.

form <- eco.formula(eco, P1 + P2 + P3 + U(A) ~ E1 + E2 + Condition(X+Y))
rda(form)

form2 <- eco.formula(eco, P1 + P2 + P3 + U(A) ~ E1 + E2 + X + Y)
lm(form2)


# parsing with magrittr
eco.formula(eco, P1 + P2 + P3 + E (A) ~ U(E) + Condition(X+Y)) \%>\% rda
}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

