% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.methods.R, R/show_summary.methods.R
\name{plot,eco.correlog,ANY-method}
\alias{plot,eco.correlog,ANY-method}
\alias{plot,eco.correlog-method}
\alias{show,eco.correlog-method}
\title{globalplot}
\usage{
\S4method{plot}{eco.correlog,ANY}(x)

\S4method{show}{eco.correlog}(object)
}
\arguments{
\item{x}{Result of correlogram or variogram analysis.}

\item{var}{Variable to plot for multiple analyses with \code{\link{eco.correlog}}
(see examples).}
}
\description{
Plot method for correlograms and variograms
}
\examples{

\dontrun{

data(eco.test)

# single Moran's I correlogram analysis
moran.example <- eco.correlog(Z=eco[[P]][,1], eco$XY, smax=10, size=1000)
plot(moran.example)

# multiple Moran's I correlogram analysis
moran.example2 <- eco.correlog(Z=eco[[P]], eco$XY, smax=10, size=1000)
plot(moran.example2, var ="P2")
plot(moran.example2, var ="P3")

corm <- eco.cormantel(M = dist(eco[[P]]), size=1000,smax=7, XY = eco$XY,
nsim = 99)
plot(corm)

variog <- eco.variogram(Z = eco[[P]][, 2],XY =  eco$XY)
plot(variog)
}

}
\seealso{
\code{\link{eco.correlog}} \code{\link{eco.cormantel}}  \code{\link{eco.variogram}}
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
\keyword{internal}
