% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.2hierfstat.R
\name{eco.2hierfstat}
\alias{eco.2hierfstat}
\title{Converting an ecogen genetic data frame into a hierfstat data frame}
\usage{
eco.2hierfstat(eco, pop = NULL)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{pop}{The name of the @S slot column with the groups
for the hierfstat data frame.}
}
\description{
This function converts the genetic
data of an ecogen object in a hierfstat data frame.
}
\examples{
\dontrun{

data(eco.test)
hiereco <- eco.2hierfstat(eco, "pop")
require("hierfstat")
basic.stats(hiereco)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

