% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.mantel.R
\name{eco.mantel}
\alias{eco.mantel}
\title{Mantel and partial Mantel tests}
\usage{
eco.mantel(d1, d2, dc = NULL, method = c("pearson", "spearman", "kendall"),
  nsim = 99, alternative = c("auto", "two.sided", "less", "greater"), ...)
}
\arguments{
\item{d1}{Distance matrix.}

\item{d2}{Distance matrix.}

\item{dc}{Distance matrix (optional).}

\item{method}{Correlation method used for the construction of the statistic 
("pearson", "spearman" or "kendall"). Kendall's tau computation is slow.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the alternative hypothesis.
Other options are: "two.sided", "greater" and "less".}

\item{...}{Additional arguments passed to \code{\link[stats]{cor}}.}
}
\value{
An object of class "eco.gsa" with the following slots:

> METHOD method used in the analysis

> OBS observed value

> EXP expect value

> PVAL P-value

> ALTER alternative hypotesis

> NSIM number of simulations


\strong{ACCESS TO THE SLOTS}
The content of the slots can be accessed 
with the corresponding accessors, using
the generic notation of EcoGenetics 
(<ecoslot.> + <name of the slot> + <name of the object>).
See help("EcoGenetics accessors") and the Examples
section below
}
\description{
This program computes the Mantel test between the distance matrices 
d1 and d2, or a partial Mantel test between the distance matrices 
d1 and d2, conditioned on dc.
}
\examples{

\dontrun{

data(eco.test)

eco.mantel(d1 = dist(eco[["P"]]), d2 = dist(eco[["E"]]), nsim = 99)   # ordinary Mantel test

pm <- eco.mantel(d1 = dist(eco[["P"]]), d2 = dist(eco[["E"]]), 
dc = dist(eco[["XY"]]), nsim = 99)                               # partial Mantel test

#-----------------------
# ACCESSORS USE EXAMPLE
#-----------------------

# the slots are accessed with the generic format 
# (ecoslot. + name of the slot + name of the object). 
# See help("EcoGenetics accessors")

ecoslot.OBS(pm)     # slot OBS (observed value)
ecoslot.PVAL(pm)    # slot PVAL (P-value) 

}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Legendre P. 2000. Comparison of permutation methods for the partial correlation
and partial Mantel tests. Journal of Statistical Computation and Simulation,
67: 37-73.

Legendre P., and M. Fortin. 2010. Comparison of the Mantel test and 
alternative approaches for detecting complex multivariate relationships 
in the spatial analysis of genetic data. Molecular Ecology Resources, 
10: 831-844.

Mantel N. 1967. The detection of disease clustering and a generalized 
regression approach. Cancer research, 27: 209-220.

Smouse P. J. Long and R. Sokal. 1986. Multiple regression and correlation 
extensions of the Mantel test of matrix correspondence. Systematic zoology, 627-632.
}

