% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.2geneland.R
\name{eco.2geneland}
\alias{eco.2geneland}
\title{Creating input data for Geneland with an ecogen object.}
\usage{
eco.2geneland(eco, ndig)
}
\arguments{
\item{eco}{ecogen object.}

\item{ndig}{Number of digits coding each allele (e.g. 1: x, 2: xx or
3: xxx) when there is more than one allele per individual locus.}
}
\value{
XY.txt matrix with coordinates.

NAMES.txt matrix with row names.

P.txt matrix with phenotypic data.

G.txt matrix with genotypic data.
}
\description{
This function creates four data frames in the workspace
(XY.txt, NAMES.txt, P.txt, G.txt) which can be loaded in Geneland.
}
\examples{
\dontrun{

data(eco.test)
eco.2geneland(eco, 1)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

