% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{stbc}
\alias{stbc}
\title{speed/turn bivariate binary Clustering.}
\usage{
stbc(obj, stdv = c(0.1, 5 * pi/180), spdLim = 40, smth = 0,
  scv = "None", maxItr = 200, info = 0)
}
\arguments{
\item{obj}{A \code{data.frame} object with (timeStamp,lon,lat) values in columns 1:3 respectively. Timestamps must be given
as.POSIXct() with specific format "\%Y-\%m-\%d \%H:\%M:\%S". Further columns of associated data are allowed and will be included in the \link{binClstPath_instance} @pth slot.

A \code{Move} object from the "move" R-package.

A \code{list} of trajectories given either as \code{data.frame} or \code{Move} objects, to perform a joined clustering of all of them. This is mainly intended to perform analysis at population level.}

\item{stdv}{a vector with bounds for the maximum precision of clusters, given as minimum standard deviation for each variable, (by default is set to 0.1 m/s for velocities and 5 degrees for turns).}

\item{spdLim}{A speed limit for automatic detection of outliers. Trajectory locations with associated values of speed above
the spdLim are not eliminated but will play no part in the clustering. By default is set to 40 m/s.}

\item{smth}{A smoothing time interval in hours. This is used to estimate local values of speed and turn computed as an average over a time window centered at each location.}

\item{scv}{A solar position covariate to be used as a daytime indicator. It can be either 'height' (the solar height in degrees above the horizon) or 'azimuth' (the solar azimuth in degrees from north). If it is used, a trivariate clustering is performed, increasing to a maximum of 8 the number of clusters (behaviours) that can potentially be identified. By default this value is set to None (i.e. perform the standard bivariate speed/turn clustering).}

\item{maxItr}{A limit to the number of iterations in case of slow convergence (defaults to 200).}

\item{info}{Level of information shown at each step:
info=0 (default) shows step likelihood, number of clusters, and number of changing labels;
info=1, include clustering statistics;
info=2, include delimiters information;
info<0, suppress any step information.}
}
\value{
Returns a binClstPath object.
}
\description{
\code{stbc} is a specific constructor for movement ecology pourposes. By default it implements a bivariate (speed/turn) clustering for behavioural annotation of animals' movement trajectories. Alternatively, it can perform a trivariate clustering by including the solar position covariate (i.e. solar height or solar azimuth) as a daytime indicator.
}
\examples{
# -- apply EMbC to the example path --
mybcp <- stbc(expth)
\dontrun{
# --- binary clustering of a Move object ---
require(move)
mybcm <- stbc(move(system.file("extdata","leroy.csv.gz",package="move")))
# --- binary clustering of a stack of trajetories ---
mybcm <- stbc(list(mypth1,mypth2,mypth3))
}
}
