% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMMIXSSL.R
\name{EMMIXSSL}
\alias{EMMIXSSL}
\title{Fitting Gaussian mixture model to the incompleted dataset with missing-data mechanism}
\usage{
EMMIXSSL(
  dat,
  zm,
  pi,
  mu,
  sigma,
  ncov,
  xi = NULL,
  type,
  iter.max = 500,
  eval.max = 500,
  rel.tol = 1e-15,
  sing.tol = 1e-20
)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{zm}{An n-dimensional vector of group partition including the missing-label, denoted as NA.}

\item{pi}{A g-dimensional  initial vector of the mixing proportions.}

\item{mu}{A initial  \eqn{p \times g} matrix of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix;
\code{ncov} = 2 for the unequal  covariance/scale matrices.#'}

\item{xi}{A 2-dimensional initial coefficient vector for a logistic function of the Shannon entropy.}

\item{type}{Two types to fit to the model, 'ign' indicates fitting the model on the basis of the missing-label mechanism ignored, and 'full' indicates fitting the model on the basis of the missing-label mechanism}

\item{iter.max}{Maximum number of iterations allowed. Defaults to 500}

\item{eval.max}{Maximum number of evaluations of the objective function allowed. Defaults to 500}

\item{rel.tol}{Relative tolerance. Defaults to 1e-15}

\item{sing.tol}{Singular convergence tolerance; defaults to 1e-20.}
}
\value{
\item{objective}{Value of objective likelihood}
\item{convergence}{Value of convergence}
\item{iteration}{Number of iteration}
\item{pi}{Estimated vector of the mixing proportions.}
\item{mu}{Estimated matrix of the location parameters.}
\item{sigma}{Estimated covariance matrix}
\item{xi}{Estimated  coefficient vector for a logistic function of the Shannon entropy}
}
\description{
Fit normal distribution to the classified data and fit a Gaussian mixture model to the unclassified data based on the missing-data mechanism
}
\examples{
n<-150
pi<-c(0.25,0.25,0.25,0.25)
sigma<-array(0,dim=c(3,3,4))
sigma[,,1]<-diag(1,3)
sigma[,,2]<-diag(2,3)
sigma[,,3]<-diag(3,3)
sigma[,,4]<-diag(4,3)
mu<-matrix(c(0.2,0.3,0.4,0.2,0.7,0.6,0.1,0.7,1.6,0.2,1.7,0.6),3,4)
dat<-rmix(n=n,pi=pi,mu=mu,sigma=sigma,ncov=2)
xi<-c(-0.5,1)
m<-rlabel(dat=dat$Y,pi=pi,mu=mu,sigma=sigma,xi=xi,ncov=2)
zm<-dat$clust
zm[m==1]<-NA
inits<-initialvalue(g=4,zm=zm,dat=dat$Y,ncov=2)
\dontrun{
fit_pc<-EMMIXSSL(dat=dat$Y,zm=zm,pi=inits$pi,mu=inits$mu,sigma=inits$sigma,xi=xi,type='full',ncov=2)
}

}
