% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_attributes.R
\name{set_attributes}
\alias{set_attributes}
\title{set_attributes}
\usage{
set_attributes(attributes, factors = NULL, col_classes = NULL)
}
\arguments{
\item{attributes}{a joined table of all attribute metadata
(such as returned by \code{\link{get_attributes}}, see details)}

\item{factors}{a table with factor code-definition pairs; see details}

\item{col_classes}{optional, list of R column classes ('ordered', 'numeric', 'factor', 'Date', or 'character', case sensitive)
will let the function infer missing 'domain' and 'measurementScale' values for attributes column.
Should be in same order as attributeNames in the attributes table, or be a named list with names corresponding to attributeNames
in the attributes table.}
}
\value{
an eml "attributeList" object
}
\description{
set_attributes
}
\details{
The attributes data frame must use only the recognized column
headers shown here.  The attributes data frame must contain columns for required metadata.
These are:

For all data:
- attributeName (required, free text field)
- attributeDefinition (required, free text field)
- measurementScale (required, "nominal", "ordinal", "ratio", "interval", or "dateTime",
 case sensitive) but it can be inferred from col_classes.
- domain (required, "numericDomain", "textDomain", "enumeratedDomain", or "dateTimeDomain",
 case sensitive) but it can be inferred from col_classes.

For numeric (ratio or interval) data:
- unit (required)

For character (textDomain) data:
- definition (required)

For dateTime data:
- formatString (required)

For factor data:
}
