% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R, R/s3_funcs.R
\name{parameters.emc.prior}
\alias{parameters.emc.prior}
\alias{parameters.emc}
\alias{parameters}
\title{Return Data Frame of Parameters}
\usage{
\method{parameters}{emc.prior}(x, selection = "mu", N = 1000, covariates = NULL, ...)

\method{parameters}{emc}(x, selection = "mu", N = NULL, resample = FALSE, ...)

parameters(x, ...)
}
\arguments{
\item{x}{An emc or emc.prior object}

\item{selection}{String designating parameter type (e.g. mu, sigma2, correlation, alpha)}

\item{N}{Integer. How many samples to take from the posterior/prior. If \code{NULL} will return the full posterior}

\item{covariates}{For priors, possible covariates in the design}

\item{...}{Optional arguments that can be passed to \code{get_pars}}

\item{resample}{Boolean. If \code{TRUE} will sample N samples from the posterior with replacement}
}
\value{
A data frame with one row for each sample
(with a subjects column if selection = "alpha" and using draws from the posterior)
}
\description{
Return Data Frame of Parameters
}
\examples{
# For prior inference:
# First set up a prior
design_DDMaE <- design(data = forstmann,model=DDM,
                       formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                       constants=c(s=log(1)))
# Then set up a prior using make_prior
p_vector=c(v_Sleft=-2,v_Sright=2,a=log(1),a_Eneutral=log(1.5),a_Eaccuracy=log(2),
           t0=log(.2),Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))
psd <- c(v_Sleft=1,v_Sright=1,a=.3,a_Eneutral=.3,a_Eaccuracy=.3,
         t0=.4,Z=1,sv=.4,SZ=1)
# Here we left the variance prior at default
prior_DDMaE <- prior(design_DDMaE,mu_mean=p_vector,mu_sd=psd)
# Get our prior samples
parameters(prior_DDMaE, N = 100)
# For posterior inference:
# Get 100 samples of the group-level mean (the default)
parameters(samples_LNR, N = 100)
# or from the individual-level parameters and mapped
parameters(samples_LNR, selection = "alpha", map = TRUE)
}
