% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{loadData}
\alias{loadData}
\title{Read data according to the design file}
\usage{
loadData(design.file)
}
\arguments{
\item{design.file}{characters to specify the path and the file name of the design file.}
}
\value{
a list of batches holding different runs of elisa, which could contain
	one or many elisa_plates with data and annotations for 
	each plate.
}
\description{
Read the design file and then load the 
data according to the information in the design file.
}
\details{
The design file contains all the information necessary
to read data. It has the following format\cr
\tabular{lllllllll}{
ExpID\tab	FileName\tab	Batch\tab	Num_Plate\tab	Date\tab	AnnotationFile\tab	Std_Conc\tab	Dir_Annotation\tab	Dir_StdConc\cr
Exp1\tab	file1.txt\tab	Batch1\tab	1\tab	9/18/2009\tab	annote.txt\tab	stdConc.txt\tab \tab \cr		
Exp2\tab	file2.txt\tab	Batch2\tab	2\tab	9/18/2009\tab	annote.txt\tab	stdConc.txt\tab \tab \cr		
}
The return data is a list of batches (\code{\link{elisa_batch-class}}), 
which are made of one or many elisa runs(\code{\link{elisa_run-class}}) 
. The
	run could contain one or many elisa plates (\code{\link{elisa_plate-class}})
	with data or annotation of each plate.\cr
 \tabular{lllllll}{
list\tab	|\tab	 \tab	 \tab	 \tab	 \tab	 \cr
 \tab	|\tab	--batch1\tab	|\tab	\tab	\tab	\cr		
 \tab	|\tab	 \tab	|\tab	--run1\tab	|\tab	\cr		
 \tab	|\tab	 \tab	|\tab	 \tab	|\tab	--plate1\cr
 \tab	|\tab	 \tab	|\tab	 \tab	|\tab	--plate2\cr
 \tab	|\tab	--batch2\tab	|\tab	\tab	\tab	\cr
 \tab	|\tab	 \tab	|\tab	\tab	\tab	\cr				
}
}
\examples{
file.dir<-system.file("extdata", package="ELISAtools")
loadData(file.path(file.dir,"design.txt"));
}
\seealso{
\code{\link{elisa_batch-class}} \code{\link{elisa_plate-class}} \code{\link{elisa_run-class}}
}
