% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchCorrection.R
\name{plotAlignData}
\alias{plotAlignData}
\title{Plot all batch data together}
\usage{
plotAlignData(batches, graph.file = NULL)
}
\arguments{
\item{batches}{list of batch data objects either raw or analyzed data.}

\item{graph.file}{characters as the output graph file name. If specified, a 
SVG (*.svg) graph will be saved to the disk. Otherwise, the graph 
will be send to the stdout.}
}
\value{
characters which specify the graph file name, if graph.file is specified. NULL
otherwise.
}
\description{
Plot the batch data together for visualization.
}
\details{
If the data has been analysed, a fitted line will be drawn too. If
there are more than one batches, each batch will be plotted with different color
and different synmbols. Different batches will also be shifted/adjusted based on their
"S" factor, and one single fitted line (based on the "reference" batch) will be plotted.
}
\examples{
#load the library
library(ELISAtools)

#get file folder
dir_file<-system.file("extdata", package="ELISAtools")

#load the data
batches<-loadData(file.path(dir_file,"design.txt"))

#plot the raw batch data together
plotAlignData(batches);


}
