% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/findLocalMax.R
\name{findLocalMax}
\alias{findLocalMax}
\alias{findLocalMax.EEM}
\alias{findLocalMax.data.frame}
\alias{findLocalMax.matrix}
\alias{findLocalMax.numeric}
\title{Find local maximum peaks}
\usage{
findLocalMax(data, ...)

\method{findLocalMax}{EEM}(data, n, threshold = 0.7, ...)

\method{findLocalMax}{matrix}(data, threshold = 0.7, ...)

\method{findLocalMax}{data.frame}(data, threshold = 0.7, ...)

\method{findLocalMax}{numeric}(data, threshold = 0.7, ...)
}
\arguments{
\item{data}{EEM data generated by \code{\link{readEEM}} function, or a matrix or dataframe with
columns = excitation and rows = emission wavelengths.}

\item{...}{(optional) further arguments passed to other methods}

\item{n}{sample number. The number should not exceed \code{length(EEM)}.}

\item{threshold}{threshold value ranging from 0 ~ 1. Lower the value to cover low peaks.}
}
\value{
Print a dataframe of local maximum peaks and return a character vector of peak names.
}
\description{
Find local maximum peaks in EEM data
}
\section{Methods (by class)}{
\itemize{
\item \code{EEM}: for EEM data created by \code{\link{readEEM}} function

\item \code{matrix}: for a matrix with columns being
excitation wavelength and rows being emission wavelength

\item \code{data.frame}: for a dataframe with columns being
excitation wavelength and rows being emission wavelength

\item \code{numeric}: for a vector of numeric values which have names in
the format of EX...EM...
}}
\examples{
data(applejuice)
findLocalMax(applejuice, 1)
}

