% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_event_subscription_schema.R
\name{get_event_subscription_schema}
\alias{get_event_subscription_schema}
\title{Get event subscription schema}
\usage{
get_event_subscription_schema(env = "production")
}
\arguments{
\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document) Schema for event subscription creation request
entities.

See the 
\href{https://CRAN.R-project.org/package=xml2}{xml2} library 
for more on working with XML.
}
\description{
Get event subscription schema
}
\examples{
\dontrun{

# Get schema
schema <- get_event_subscription_schema()
schema
#> {xml_document}
#> <schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
#> [1] <xs:element name="subscription">\n  <xs:complexType>\n    <xs:    ...

# Show schema structure
xml2::xml_structure(schema)
#> <schema [xmlns:xs]>
#>   <element [name]>
#>     <complexType>
#>       <all>
#>         <element [name, type, minOccurs, maxOccurs]>
#>         <element [name, type, minOccurs, maxOccurs]>
#>       <attribute [name, type, use, fixed]>
}
}
\seealso{
Other Event Notifications: 
\code{\link{create_event_subscription}()},
\code{\link{delete_event_subscription}()},
\code{\link{execute_event_subscription}()},
\code{\link{get_event_subscription}()},
\code{\link{query_event_subscriptions}()}
}
\concept{Event Notifications}
