% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_journal_citation.R
\name{create_journal_citation}
\alias{create_journal_citation}
\title{Create journal citation}
\usage{
create_journal_citation(
  packageId,
  articleDoi = NULL,
  articleUrl = NULL,
  articleTitle = NULL,
  journalTitle = NULL,
  relationType,
  env = "production"
)
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{articleDoi}{(character) Article DOI. Required if \code{articleUrl} is
missing.}

\item{articleUrl}{(character) Article URL. Required if \code{articleDoi} is
missing.}

\item{articleTitle}{(character) Article title}

\item{journalTitle}{(character) Journal title}

\item{relationType}{(character) Relation between citation and data package.
Can be: "IsCitedBy" this data package is formally cited in the manuscript;
"IsDescribedBy" - this data package is explicitly described within the
manuscript; "IsReferencedBy" - this data package is implicitly described
within the manuscript.}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Journal citation identifier
}
\description{
Create journal citation
}
\details{
Creates a new journal citation entry in the EDI data repository
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create journal citation
journalCitationId <- create_journal_citation(
  packageId = "edi.17.1",
  articleDoi = "10.1890/11-1026.1",
  articleTitle = "Corridors promote fire via connectivity and edge effects",
  journalTitle = "Ecological Applications",
  relationType = "IsCitedBy",
  env = "staging"
)
journalCitationId
#> [1] 74

# Delete journal citation
delete_journal_citation(journalCitationId, env = "staging")
#> [1] TRUE

logout()
}

}
\seealso{
Other Journal Citations: 
\code{\link{delete_journal_citation}()},
\code{\link{get_journal_citation}()},
\code{\link{list_data_package_citations}()},
\code{\link{list_principal_owner_citations}()}
}
\concept{Journal Citations}
