% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{harmonize_subjid}
\alias{harmonize_subjid}
\title{Harmonize the subject ID of the database}
\usage{
harmonize_subjid(datalist, preprocess = NULL, col_subjid = get_subjid_cols())
}
\arguments{
\item{datalist}{a list of dataframes}

\item{preprocess}{an optional function to modify the subject ID column, for example \code{as.numeric()}. See examples.}

\item{col_subjid}{the names of the columns holding the subject ID (as character)}
}
\value{
datalist, with subject id modified
}
\description{
Turns the subject ID columns of all datasets into a factor containing levels for all
the subjects of the database. Avoid problems when joining tables, and some checks can
be performed on the levels.
}
\examples{
db = edc_example()
db$db0 = head(db$db0, 10)
db$db0$SUBJID \%>\% head()
db = harmonize_subjid(db)
db$db0$SUBJID \%>\% head()
db = harmonize_subjid(db, preprocess=function(x) paste0("#", x))
db$db0$SUBJID \%>\% head()
}
