% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ranks.R
\name{plot_ranks}
\alias{plot_ranks}
\title{Plot individual ranks or scores}
\usage{
plot_ranks(ranks, type = c("rank", "stan.rank", "score"))
}
\arguments{
\item{ranks}{A dataframe of ranks. There should be one row per contestant per
study period. Must include at least the following columns:
   \describe{
     \item{period}{Study periods. They should appear in chronological order.}
     \item{id}{The identity of each contestant. Each contestant should appear
     once per study period.}
     \item{rank}{The rank of each contestant in each study period. This can be
     absolute rank or standardized rank. Only required if \strong{type}
     is 'rank'.}
     \item{score}{The score of each contestant. Only required if \strong{type}
     is 'score'.}
   }}

\item{type}{A character string, either 'score', 'rank', or 'stan.rank'. Determines
whether scores, ranks, or standardized ranks are plotted.}
}
\description{
Plot ranks of individuals in a single social group over multiple study periods.
}
\examples{
female.ranks <- informed_elo(contestants = C.crocuta.female$contestants, convention = 'mri',
initial.ranks = C.crocuta.female$initial.ranks,
interactions = C.crocuta.female$interactions)

plot_ranks(female.ranks, type = 'rank')
plot_ranks(female.ranks, type = 'score')
plot_ranks(female.ranks, type = 'stan.rank')

}
