% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requirePriorDrugWashout}
\alias{requirePriorDrugWashout}
\title{Restrict cohort to only cohort records with a given amount of time since the
last cohort record ended}
\usage{
requirePriorDrugWashout(
  cohort,
  days,
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{days}{The number of days required to have passed since the last cohort
record finished. Any records with fewer days than this will be dropped. Note
that setting days to Inf will lead to the same result as that from using the
\code{requireIsFirstDrugEntry} function (with only an individual´s first cohort
record kept).}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}
}
\value{
The cohort table having applied the washout requirement.
}
\description{
Filter the cohort table keeping only the cohort records for which the
required amount of time has passed since the last cohort entry ended for that
individual.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requirePriorDrugWashout(days = 90)

attrition(cdm$cohort1) |>
  glimpse()
}

}
