% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelpers.R
\name{drugUtilisationDoc}
\alias{drugUtilisationDoc}
\title{Helper for consistent documentation of \code{add}/\code{summariseDrugUtilisation}
functions.}
\arguments{
\item{numberExposures}{Whether to include 'number_exposures' (number of drug
exposure records between indexDate and censorDate).}

\item{numberEras}{Whether to include 'number_eras' (number of continuous
exposure episodes between indexDate and censorDate).}

\item{daysExposed}{Whether to include 'days_exposed' (number of days that the
individual is in a continuous exposure episode, including allowed treatment
gaps, between indexDate and censorDate; sum of the length of the different
drug eras).}

\item{daysPrescribed}{Whether to include 'days_prescribed' (sum of the number
of days for each prescription that contribute in the analysis).}

\item{timeToExposure}{Whether to include 'time_to_exposure' (number of days
between indexDate and the first episode).}

\item{initialExposureDuration}{Whether to include 'initial_exposure_duration'
(number of prescribed days of the first drug exposure record).}

\item{initialQuantity}{Whether to include 'initial_quantity' (quantity of the
first drug exposure record).}

\item{cumulativeQuantity}{Whether to include 'cumulative_quantity' (sum of
the quantity of the different exposures considered in the analysis).}

\item{initialDailyDose}{Whether to include 'initial_daily_dose_\{unit\}'
(daily dose of the first considered prescription).}

\item{cumulativeDose}{Whether to include 'cumulative_dose_\{unit\}' (sum of
the cumulative dose of the analysed drug exposure records).}

\item{exposedTime}{deprecated.}
}
\description{
Helper for consistent documentation of \code{add}/\code{summariseDrugUtilisation}
functions.
}
\keyword{internal}
