% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIntersect.R
\name{addTreatment}
\alias{addTreatment}
\title{Add a variable indicating individuals medications}
\usage{
addTreatment(
  cohort,
  treatmentCohortName,
  treatmentCohortId = NULL,
  window = list(c(0, 0)),
  indexDate = "cohort_start_date",
  censorDate = NULL,
  mutuallyExclusive = TRUE,
  nameStyle = NULL,
  name = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{treatmentCohortName}{Name of treatment cohort table}

\item{treatmentCohortId}{target cohort Id to add treatment}

\item{window}{time window of interests.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{mutuallyExclusive}{Whether to consider mutually exclusive categories
(one column per window) or not (one column per window and treatment).}

\item{nameStyle}{Name style for the treatment columns. By default:
'treatment_\{window_name\}' (mutuallyExclusive = TRUE),
'treatment_\{window_name\}_\{cohort_name\}' (mutuallyExclusive = FALSE).}

\item{name}{Name of the new computed cohort table, if NULL a temporary table
will be created.}
}
\value{
The original table with a variable added that summarises the
individual´s indications.
}
\description{
Add a variable to a drug cohort indicating their presence of a medication
cohort in a specified time window.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CDMConnector)
library(dplyr)

cdm <- mockDrugUtilisation(numberIndividuals = 50)


cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "drug_cohort", ingredient = "acetaminophen"
)

cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "treatments", ingredient = c("metformin", "simvastatin")
)

cdm$drug_cohort |>
  addTreatment("treatments", window = list(c(0, 0), c(1, 30), c(31, 60))) |>
  glimpse()
}

}
