% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugUtilisation.R
\name{summariseDrugUtilisation}
\alias{summariseDrugUtilisation}
\title{This function is used to summarise the dose utilisation table over multiple
cohorts.}
\usage{
summariseDrugUtilisation(
  cohort,
  strata = list(),
  estimates = c("q25", "median", "q75", "mean", "sd", "count_missing",
    "percentage_missing"),
  ingredientConceptId = NULL,
  conceptSet = NULL,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  gapEra = 1,
  numberExposures = TRUE,
  numberEras = TRUE,
  exposedTime = TRUE,
  timeToExposure = TRUE,
  initialQuantity = TRUE,
  cumulativeQuantity = TRUE,
  initialDailyDose = TRUE,
  cumulativeDose = TRUE
)
}
\arguments{
\item{cohort}{Cohort with drug use variables and strata.}

\item{strata}{Stratification list.}

\item{estimates}{Estimates that we want for the columns.}

\item{ingredientConceptId}{Ingredient OMOP concept that we are interested for
the study. It is a compulsory input, no default value is provided.}

\item{conceptSet}{List of concepts to be included. If NULL all the
descendants of ingredient concept id will be used.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{numberExposures}{Whether to add a column with the number of exposures.}

\item{numberEras}{Whether to add a column with the number of eras.}

\item{exposedTime}{Whether to add a column with the number of exposed days.}

\item{timeToExposure}{Whether to add a column with the number of days between
indexDate and start of the first exposure.}

\item{initialQuantity}{Whether to add a column with the initial quantity.}

\item{cumulativeQuantity}{Whether to add a column with the cumulative
quantity of the identified prescription.}

\item{initialDailyDose}{Whether to add a column with the initial daily dose.}

\item{cumulativeDose}{Whether to add a column with the cumulative dose.}
}
\value{
A summary of drug utilisation stratified by cohort_name and strata_name
}
\description{
This function is used to summarise the dose utilisation table over multiple
cohorts.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
codelist <- CodelistGenerator::getDrugIngredientCodes(cdm, "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(
  cdm, "dus_cohort", codelist
)
cdm[["dus_cohort"]] \%>\%
  summariseDrugUtilisation(ingredientConceptId = 1125315)
}

}
