% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R
\name{runDockerWorkers}
\alias{runDockerWorkers}
\title{Run the worker container}
\usage{
runDockerWorkers(provider, cluster, container, hardware, workerNumber, verbose)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{container}{S4 \code{DockerContainer} Object. The worker container.}

\item{hardware}{S4 \code{DockerHardware} Object. The worker hardware.}

\item{workerNumber}{Integer. The number of workers needs to be run.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
A list of object that can be used by the cluster to identify the worker instances.
The lenght must be equal to \code{workerNumber}
}
\description{
Run the workers and return a list of worker instance handles. The instance handles
can be duplicated if multiple workers share the same instance. There is no default method
for this generic.
}
\section{Instance Handle}{

The instance handle is nothing but any data type that can be used by the
cloud provider to identify the running container. The data type should
supports \code{identical} and \code{unique} functions. The \code{DockerParallel} object will use the
handle to check the instance status or kill the instance. Though it is not required,
but we recommend to use \code{character} as the instance handle.
}

