% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{model.diversity}
\alias{model.diversity}
\title{Find the best GLM model explaining the alpha divesity of the species}
\usage{
model.diversity(DivOcc, method = "h", delta = 2, squared = FALSE)
}
\arguments{
\item{DivOcc}{is an object returned by the divesityoccu function of this
package}

\item{method}{The method to be used to explore the candidate set of models.
If "h" an exhaustive screening is undertaken. If "g" the genetic algorithm is
employed (recommended for large candidate sets). If "l", a very fast
exhaustive branch-and-bound algorithm is used. Package leaps must then be
loaded, and this can only be applied to linear models with covariates and no
interactions.}

\item{delta}{The number of models that will be returned will be the ones that
have a maximum AICc difference with the top model equal to delta.}

\item{squared, }{if FALSE (Default), only GLMs with linear components will be
evaluated; If TRUE, GLMs with both linear and quadratic components will be evaluated.
WARNING if squared is TRUE, the number of parameters duplicates and the models
grow exponentially, this may result in to many variables for a CPU to compute.}
}
\value{
An object with the best fitted model, the coefficients of that model,
a table with the top 5 fitted models ranked by AICc and the data used for the
model
}
\description{
This function takes a diversityoccu object and heuristically searches for the
glm that best explains the alpha diversity of the modelled species.
}
\details{
This function fits every first order glm possible and ranks them by AICc.
}
\examples{
\dontrun{
#Load the data
data("BatOccu")
data("Dailycov")
data("sampling.cov")

#Model the abundance for 17 bat species and calculate alpha diversity from that

BatDiversity <-diversityoccu(pres = BatOccu, sitecov = sampling.cov,
obscov = Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~ Burn.intensity.soil + I(Burn.intensity.soil^2) +
Burn.intensity.Canopy + I(Burn.intensity.Canopy^2) + Burn.intensity.basal +
I(Burn.intensity.basal^2))

#Select the best model that explains diversity using genetic algorithms
set.seed(123)
glm.Batdiversity <- model.diversity(BatDiversity, method = "g")

#see the best models

glm.Batdiversity$Best.model

#plot the response of diversity to individual variables

plot(glm.Batdiversity, Burn.intensity.soil)

#To add the quadratic components of models

batdiversity <-diversityoccu(pres = BatOccu, sitecov = sampling.cov,
obscov = Dailycov, spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~Burn.intensity.soil + I(Burn.intensity.soil^2) + Burn.intensity.Canopy +
I(Burn.intensity.Canopy^2) + Burn.intensity.basal +I(Burn.intensity.basal^2))
set.seed(123)
glm.batdiversity <- model.diversity(batdiversity , method = "g", squared = TRUE)

responseplot.diver(glm.batdiversity, Burn.intensity.Canopy)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}
}

