% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sites_scatter_H.R
\name{plot_sites_scatter_H}
\alias{plot_sites_scatter_H}
\title{Plot H against Date}
\usage{
plot_sites_scatter_H(
  clusterised_object,
  xlabel = "Date",
  ylabel = "Diversity (H)",
  main_title = "Shannon's H over Time"
)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites function.}

\item{xlabel}{The X axis label with "Date" as default.}

\item{ylabel}{The Y axis label with "Diversity (H)" as default.}

\item{main_title}{The main label with "Shannon's H over Time" as default.}
}
\value{
Returns a ggplot2 scatter plot in the plot panel, showing the relationship between dates and diversity index values.
}
\description{
Plot Shannon's H on the Y axis and dates on the X axis with scaled spacing for each date and scattered points.
}
\examples{
# create a scatter plot showing the diversity over time at the Caquetá province
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

clusterised_Caquetá <- clusterise_sites(dataframe = Colombia_Caquetá_dataframe,
                                       cluster_min_length = 30,
                                       group_radius = 20000
)

plot_sites_scatter_H(clusterised_Caquetá)
}
