% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaR_erlang.R
\name{VaR_erlang}
\alias{VaR_erlang}
\title{Value-at-Risk of the Erlang distribution}
\usage{
VaR_erlang(kap, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{kap}{probability.}

\item{shape}{shape parameter \eqn{n}, must be positive integer.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_erlang}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{derlang}}}{ gives the density function.}
 \item{\code{\link{perlang}}}{ gives the cumulative density function.}
 \item{\code{\link{E_erlang}}}{ gives the expected value.}
 \item{\code{\link{V_erlang}}}{ gives the variance.}
 \item{\code{\link{kthmoment_erlang}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_erlang}}}{ gives the truncated mean.}
 \item{\code{\link{SL_erlang}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_erlang}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_erlang}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_erlang}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_erlang}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Value-at-Risk of the Erlang distribution with shape parameter
 \eqn{n}{n} and rate parameter \eqn{\beta}{beta}.
}
\details{
The Erlang distribution with shape parameter \eqn{n} and rate parameter
  \eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\beta^{n}}{\Gamma(n)} x^{n - 1}%
   \mathrm{e}^{-\beta x}}{f(x) = b^n / \Gamma(n) x^{n - 1} e^{-b x}}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0}, \eqn{n \in \mathcal{N}^+}{n = 1, 2, 3, ...}
}
\note{
Wrapper of qgamma from package stats.
}
\examples{

# With scale parameter
VaR_erlang(kap = .2, shape = 3, scale = 4)

# With rate parameter
VaR_erlang(kap = .2, shape = 3, rate = 0.25)

}
\seealso{
Other Erlang Distribution: 
\code{\link{E_erlang}()},
\code{\link{Elim_erlang}()},
\code{\link{Etronq_erlang}()},
\code{\link{MGF_erlang}()},
\code{\link{Mexcess_erlang}()},
\code{\link{SL_erlang}()},
\code{\link{TVaR_erlang}()},
\code{\link{V_erlang}()},
\code{\link{derlang}()},
\code{\link{kthmoment_erlang}()},
\code{\link{perlang}()}
}
\concept{Erlang Distribution}
