#' Limited mean of the Burr distribution
#'
#' @description Limited mean of the Burr distribution with shape
#'  \eqn{\alpha}{alpha} (shape1) and \eqn{\tau}{tau} (shape2) as well as
#'  rate parameter \eqn{\lambda}{lambda}.
#'
#' @templateVar d TRUE
#' @template burr-template
#'
#' @export
#' @importFrom stats pbeta
#'
#' @examples
#'
#' # With rate parameter
#' Elim_burr(d = 2, rate = 2, shape1 = 2, shape2 = 5)
#'
#' # With scale parameter
#' Elim_burr(d = 2, scale = 0.5, shape1 = 2, shape2 = 5)
#'
Elim_burr <- function(d, shape1, shape2, rate = 1 / scale, scale = 1 / rate) {
    stopifnot(shape1 > 0, shape2 > 0, rate > 0, d >= 0, shape1 * shape2 > 1)

    E_burr(shape1, shape2, rate) *
        stats::pbeta(q = d^shape2 / (rate + d^shape2),
              shape1 = 1 + 1/shape2,
              shape2 = shape1 - 1/shape2) +
        d *
        (rate / (rate + d^shape2))^shape1
}
