% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POISXL.R
\name{POISXL}
\alias{POISXL}
\title{The Discrete Poisson XLindley}
\usage{
POISXL(mu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}
}
\value{
Returns a \code{gamlss.family} object which can be used
to fit a Discrete Poisson XLindley distribution
in the \code{gamlss()} function.
}
\description{
The function \code{POISXL()} defines  the Discrete Poisson XLindley distribution, one-parameter
discrete distribution, for a \code{gamlss.family} object to be used in GAMLSS fitting
using the function \code{gamlss()}.
}
\details{
The Discrete Poisson XLindley distribution with parameters \eqn{\mu} has a support
0, 1, 2, ... and mass function given by

\eqn{f(x | \mu) = \frac{\mu^2(x+\mu^2+3(1+\mu))}{(1+\mu)^{4+x}}}; with \eqn{\mu>0}.

Note: in this implementation we changed the original parameters \eqn{\alpha} for \eqn{\mu},
we did it to implement this distribution within gamlss framework.
}
\examples{
# Example 1
# Generating some random values with
# known mu
y <- rPOISXL(n=1000, mu=1)

# Fitting the model
library(gamlss)
mod1 <- gamlss(y~1, family=POISXL,
               control=gamlss.control(n.cyc=500, trace=FALSE))

# Extracting the fitted values for mu
# using the inverse link function
exp(coef(mod1, what='mu'))

# Example 2
# Generating random values under some model

# A function to simulate a data set with Y ~ POISXL
gendat <- function(n) {
  x1 <- runif(n, min=0.4, max=0.6)
  mu <- exp(1.21 - 3 * x1) # 0.75 approximately
  y <- rPOISXL(n=n, mu=mu)
  data.frame(y=y, x1=x1)
}

dat <- gendat(n=1500)

# Fitting the model
mod2 <- NULL
mod2 <- gamlss(y~x1, family=POISXL, data=dat,
               control=gamlss.control(n.cyc=500, trace=FALSE))

summary(mod2)
}
\references{
\insertRef{ahsan2022}{DiscreteDists}
}
\seealso{
\link{dPOISXL}.
}
\author{
Mariana Blandon Mejia, \email{mblandonm@unal.edu.co}
}
