`covMat1Mat2` <-
function(X1, X2, covStruct, nugget.flag=FALSE) {

	# X1 : matrix n1 x d - containing training points
	# X2 : matrix n2 x d - containing test points
	
	n1 <- nrow(X1)
	n2 <- nrow(X2)
	d <- ncol(X1)
	
	param <- covparam2vect(covStruct)
	
	out <- .C("C_covMat1Mat2", 
				as.double(X1), as.integer(n1),
				as.double(X2), as.integer(n2), 
				as.integer(d),
				as.double(param), as.double(covStruct@sd2), as.character(covStruct@name),
				ans = double(n1 * n2), PACKAGE="DiceKriging")
				
	M <- matrix(out$ans, n1, n2)
	
	if ((!nugget.flag) | (!covStruct@nugget.flag)) {
		return(M)
	} else {
		out <- .C("C_covMat1Mat2", 
				as.double(X1), as.integer(n1),
				as.double(X2), as.integer(n2), 
				as.integer(d),
				as.double(param), as.double(covStruct@nugget), "whitenoise",
				ans = double(n1 * n2), PACKAGE="DiceKriging")
		N <- matrix(out$ans, n1, n2)
		return(M+N)
	}
		
}