% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attrs.R
\name{set_node_attrs}
\alias{set_node_attrs}
\title{Set node attribute values}
\usage{
set_node_attrs(graph, node_attr, values, nodes = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr}{The name of the attribute to set.}

\item{values}{The values to be set for the chosen attribute for the chosen
nodes.}

\item{nodes}{An optional vector of node IDs for filtering the list of nodes
present in the graph.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, set node attribute values for one
or more nodes.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Set attribute `color = "green"` for
# nodes `1` and `3` using the graph object
graph <-
  graph \%>\%
  set_node_attrs(
    node_attr = color,
    values = "green",
    nodes = c(1, 3))

# View the graph's node data frame
graph \%>\% get_node_df()

# Set attribute `color = "blue"` for
# all nodes in the graph
graph <-
  graph \%>\%
  set_node_attrs(
    node_attr = color,
    values = "blue")

# Display the graph's ndf
graph \%>\% get_node_df()

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
