% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trav_in_until.R
\name{trav_in_until}
\alias{trav_in_until}
\title{Traverse inward node-by_node until stopping conditions are met}
\usage{
trav_in_until(graph, conditions, max_steps = 30, exclude_unmatched = TRUE,
  add_to_selection = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{conditions}{an option to use a
stopping condition for the traversal.
If the condition is met during the
traversal (i.e., the node(s) traversed
to match the condition), then those
traversals will terminate at those
nodes. Otherwise, traversals with
continue and terminate when the number
of steps provided in \code{max_steps}
is reached.}

\item{max_steps}{the maximum number
of \code{trav_in()} steps (i.e.,
node-to-node traversals in the inward
direction) to allow before stopping.}

\item{exclude_unmatched}{if \code{TRUE}
(the default value) then any nodes not
satisfying the conditions provided in
\code{conditions} that are in the ending
selection are excluded.}

\item{add_to_selection}{if \code{TRUE}
then every node traversed will be part
of the final selection of nodes. If
\code{FALSE} (the default value) then
only the nodes finally traversed to
will be part of the final node
selection.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
From a graph object of
class \code{dgr_graph}, move along
inward edges from one or more nodes
present in a selection to other
connected nodes, replacing the current
nodes in the selection with those nodes
traversed to until reaching nodes that
satisfy one or more conditions.
}
\examples{
# Create a path graph and add
# values of 1 to 10 across the
# nodes from beginning to end;
# select the last path node
graph <-
  create_graph() \%>\%
  add_path(
    n = 10,
    node_data = node_data(
      value = 1:10)) \%>\%
  select_nodes_by_id(
    nodes = 10)

# Traverse inward, node-by-node
# until stopping at a node where
# the `value` attribute is 1
graph <-
  graph \%>\%
  trav_in_until(
    conditions =
      value == 1)

# Get the graph's node selection
graph \%>\%
  get_selection()

# Create two cycles in a graph and
# add values of 1 to 6 to the
# first cycle, and values 7 to
# 12 in the second; select nodes
# `6` and `12`
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 6,
    node_data = node_data(
      value = 1:6)) \%>\%
  add_cycle(
    n = 6,
    node_data = node_data(
      value = 7:12)) \%>\%
  select_nodes_by_id(
    nodes = c(6, 12))

# Traverse inward, node-by-node
# from `6` and `12` until stopping
# at the first nodes where the
# `value` attribute is 1, 2, or 10;
# specify that we should only
# keep the finally traversed to
# nodes that satisfy the conditions
graph <-
  graph \%>\%
  trav_in_until(
    conditions =
      value \%in\% c(1, 2, 10),
    exclude_unmatched = TRUE)

# Get the graph's node selection
graph \%>\%
  get_selection()
}
