% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_to_complement_graph.R
\name{transform_to_complement_graph}
\alias{transform_to_complement_graph}
\title{Create a complement of a graph}
\usage{
transform_to_complement_graph(graph, loops = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{loops}{an option for whether loops should
be generated in the complement graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Create a complement graph which
contains only edges not present in the input graph.
It's important to nodes that any edge attributes
in the input graph's edges will be lost. Node
attributes will be retained, since they are
not affected by this transformation.
}
\examples{
# Create a simple graph
# with a single cycle
graph <-
  create_graph() \%>\%
  add_cycle(n = 4)

# Get the graph's edge
# data frame
graph \%>\%
  get_edge_df()

# Create the complement
# of the graph
graph_c <-
  graph \%>\%
    transform_to_complement_graph()

# Get the edge data frame
# for the complement graph
graph_c \%>\%
  get_edge_df()
}
