% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rev_edge_dir.R
\name{rev_edge_dir}
\alias{rev_edge_dir}
\title{Reverse the direction of all edges in a graph}
\usage{
rev_edge_dir(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Using a directed graph as input,
reverse the direction of all edges in that graph.
}
\examples{
# Create a graph with a
# directed tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 2)

# Inspect the graph's edges
graph \%>\%
  get_edges()

# Reverse the edge directions
# such that edges are directed
# toward the root of the tree
graph <-
  graph \%>\%
  rev_edge_dir()

# Inspect the graph's edges
# after their reversal
graph \%>\%
  get_edges()
}
