% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_edges.R
\name{count_edges}
\alias{count_edges}
\title{Get a count of all edges}
\usage{
count_edges(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single-length numeric
vector.
}
\description{
From a graph object of
class \code{dgr_graph}, get a count
of edges in the graph.
}
\examples{
# Create a graph with a
# path of nodes and 3
# unconnected nodes
graph <-
  create_graph() \%>\%
  add_path(n = 3) \%>\%
  add_n_nodes(n = 3)

# Get a count of all edges
# in the graph
graph \%>\%
  count_edges()
}
